#include <config.h>

#ifdef OBSOLETED
 
/* 
   Native methods for ClassLoader 
 
  public abstract class ClassLoader 
  { 
    protected abstract Class loadClass(String name, boolean resolve) throws ClassNotFoundException; 
    protected native final Class defineClass(String name, byte data[], int offset, int length); 
    protected native final void resolveClass(Class c); 
    protected native final Class findSystemClass(String name) throws ClassNotFoundException; 
    private native void init(); 
  } 
 
*/ 

#include "jni.h"
#include "interp.h"
#include "interp_methods.h"

#include "newobject.h" 
#include "classfile_methods.h"

#include "cptuplelist.h"
#include "Class.h"
#include "Class_Reflection.h"
#include "ClassLoader.h"

extern tOBREF OOMExceptionObject;
extern tClassLoaderTuple* pstClassType; // this can be globally used to get the type for class


/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: protected native final Class defineClass(String name, byte data[], int offset, int length); 
 * 
 * Returns a class defined from the data in the array of bytes. 
 * 
 */ 
 
jclass Java_java_lang_ClassLoader_defineClass 
( 
  JNIEnv* env, 
  jobject obj, 
  jobject string, 
  jarray data, 
  jint offset, 
  jint length 
) 
{ 
  tARREF  pstDataArray = data; 
  int32    i32Offset = offset; 
  int32    i32Length = length; 
  byte*    pbData; 
  tClassLoaderTuple*  pstClass; 
  tOBREF pstClassObject; 
  uint32 errorCode;
  char* pszNameString;

  if (pstDataArray == NULL) 
  { 
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/NullPointerException")); 
    return NULL; 
  } 
 
  if ((i32Offset < 0) || (i32Length < 0) || (i32Offset + i32Length > ADEREF(pstDataArray)->i32Number)) 
  { 
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/IndexOutOfBoundsException")); 
    return NULL; 
  } 
 
  pbData = (byte*) ADEREF(pstDataArray)->pvElements; 
  pbData += i32Offset; 

  pszNameString = INTERP_AscizFromString(env, string);

  pstClass = CLASSFILE_ClassCreate(env, pbData, pszNameString, &errorCode); 
  
  sys_free(pszNameString);
  if (pstClass == NULL) 
  { 
    (*env)->Throw(env, INTERP_NewObjectFromName(env, "java/lang/ClassFormatError")); 
    return NULL; 
  } 
 
  pstClassObject = INTERP_NewObjectFromName(env, "java/lang/Class"); 
  pstClass->classObject = pstClassObject; 
  CLASS_SetClassStruct(pstClassObject, pstClass); 
  CLASS_SetClassLoader(pstClassObject, obj);
 
  if (CPTUPLELIST_UidFind(pstClass->uidName) == NULL) 
  { 
    CPTUPLELIST_Insert(pstClass); 
  } 
  return pstClassObject; 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: protected native final void resolveClass(Class c); 
 * 
 * Resolves the specified class. 
 * 
 */ 
 
void Java_java_lang_ClassLoader_resolveClass 
( 
  JNIEnv* env, 
  jobject obj, 
  jclass clazz 
) 
{ 
  tOBREF pstClassObject = clazz; 
  tClassLoaderTuple* pstClass; 
 
  if (pstClassObject == NULL) 
  { 
    (*env)->Throw(env, INTERP_NewObjectFromName(env,"java/lang/NullPointerException")); 
    return; 
  } 
 
  pstClass = CLASS_GetClassStruct(env, pstClassObject); 
  /* check if it's already linked */ 
  if (CPTUPLELIST_UidFind(pstClass->uidName)) 
  { 
    return; 
  } 
  CPTUPLELIST_Insert(pstClass); 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: protected native final Class findSystemClass(String name); 
 * 
 * Loads the specified class platform-dependently from the local file system. 
 * 
 */ 
 
jclass Java_java_lang_ClassLoader_findSystemClass 
( 
  JNIEnv* env, 
  jobject obj, 
  jobject name 
) 
{ 
  tOBREF pstNameObject = name; 
  tClassLoaderTuple* pstClass; 
  char* pszClassName; 
  tOBREF pstClassObject; 
  tOBREF pstExOb;

  pszClassName = INTERP_AscizFromString(env,pstNameObject); 
  pstClass = CLASSFILE_FindOrLoad(env,pszClassName, pstClassType );  //XXX System loader?
  sys_free(pszClassName);

  if (pstClass == NULL) 
  { 
    (*env)->Throw(env, INTERP_NewObjectFromName(env,"java/lang/ClassNotFoundException")); 
    return NULL; 
  } 
 
  pstClassObject = INTERP_NewObjectFromName(env,"java/lang/Class"); 
  pstClass->classObject = pstClassObject; 
  CLASS_SetClassStruct(pstClassObject, pstClass); 
  CLASS_SetClassLoader(pstClassObject, obj); 
  //  free(pszClassName); //why free? 
  pstExOb = CLASSFILE_InitClass(env, pstClass); 
  if(pstExOb)
    {
      //Construct a java.lang.ExceptionInInitializerError
      jobject newExOb;
      jclass exClass = (*env)->FindClass(env, "java/lang/ExceptionInInitializerError");
      
      jmethodID methodID = (*env)->GetMethodID(env, exClass, "<init>", "(Ljava/lang/Throwable;)V");
      if(methodID == NULL)
	{
	  (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env,"java/lang/InternalError", "Could not find constructor method for java.lang.ExceptionInInitializerError"));
	  return NULL;
	}
      newExOb = (*env)->NewObject(env, exClass, methodID, pstExOb);
      if(newExOb == NULL) { 	  (*env)->Throw(env, OOMExceptionObject); }
      (*env)->Throw(env, newExOb);
      return NULL;
    }
  return pstClassObject; 
} 
 
/* 
 * @doc NATFUNC 
 * @func 
 * Implementation of: private native void init(); 
 * 
 * Initialises the class loader. We don't actually do anything here. 
 * 
 */ 
 
int Java_java_lang_ClassLoader_init 
( 
  JNIEnv* env, 
  jobject obj 
) 
{ 
  /* don't need to do anything here */ 
  return 0; 
}


#endif
