#include "kptransferdialog.h"
#include "hrmdata.h"
#include "s410.h"

#include "../../gui/kpmainwindow.h"
#include "../../kipina-i18n.h"
#include "../../kpworkout.h"
#include "../../kpplugin.h"
#include "../../kputil.h"

/*static KPWorkout *    analyze_s410_data (HrmData *hrm_data, gint *data,
                                         gint size);*/
GtkWidget *menu_item;

static void
menu_item_clicked (GtkMenuItem *item, gpointer data)
{
  GtkWidget *dialog;
  KPWorkout *workout;

  dialog = kp_transfer_dialog_new (&workout);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

static gboolean
plugin_load(KPPlugin *plugin)
{
  if (menu_item)
    return TRUE;
  
  menu_item = gtk_menu_item_new_with_label (
      "Read Polar S410 data from WAV file.. (This plugin doesn't work yet!)");
  kp_main_window_add_to_import_menu (GTK_MENU_ITEM (menu_item));

  g_signal_connect (G_OBJECT (menu_item), "activate",
                    G_CALLBACK (menu_item_clicked), NULL);
    
  return TRUE;
}

static gboolean
plugin_unload(KPPlugin *plugin)
{
  kp_debug("simple plugin unloaded.\n");

  gtk_widget_destroy (menu_item);
  menu_item = NULL;
  
  return TRUE;
}

static KPPluginInfo info =
{
  1,                                                /**< api_version    */
  "s410-tura",                                      /**< id             */
  N_("HRM Reader Plugin"),                          /**< name           */
  VERSION,                                          /**< version        */
  N_("Read Polar S410 Heart Rate Monitor data from WAV file"),
  N_("..."),
  "Ville Kangas <ville@mirjami.net>",               /**< author         */
  "http://mirjami.net/~ville/kipina",               /**< homepage       */
  plugin_load,                                      /**< load           */
  plugin_unload,                                    /**< unload         */
  NULL,                                             /**< destroy        */
};

static void
init_plugin(KPPlugin *plugin)
{
}


/*static KPWorkout *
analyze_s410_data (HrmData *hrm_data, gint *data, gint size)
{
  gdouble duration;
  KPWorkout *wo;
  GValue value;

  value.g_type = 0;
  g_value_init (&value, G_TYPE_UINT);
  
  g_return_val_if_fail (data != NULL, NULL);
  g_return_val_if_fail (size > 0, NULL);

  wo = kp_workout_new ();
  kp_calendar_time_set_dmy (KP_CALENDAR_ENTRY (wo)->datetime,
                            hex2dec (hrm_data->d),
                            hex2dec (hrm_data->m),
                            hex2dec (hrm_data->y));
  
  kp_calendar_time_set_hmst (KP_CALENDAR_ENTRY (wo)->datetime,
                             hex2dec (hrm_data->h),
                             hex2dec (hrm_data->min),
                             hex2dec (hrm_data->s),
                             0);

  g_print ("DMY: %u.%u.%u\n", hex2dec (hrm_data->d), hex2dec (hrm_data->m), hrm_data->y);
  g_print ("HMS: %.2u:%.2u:%.2u\n", hex2dec (hrm_data->h), hex2dec (hrm_data->min),
           hex2dec (hrm_data->s));
  
  g_value_set_uint (&value, hrm_data->avg_hr);
  kp_workout_set_param (wo, TRUE, "Average Heart Rate", &value);

  g_value_set_uint (&value, hrm_data->max_hr);
  kp_workout_set_param (wo, TRUE, "Max Heart Rate", &value);

  duration = hex2dec (hrm_data->duration_h) * 3600 +
             hex2dec (hrm_data->duration_m) * 60 +
             hex2dec (hrm_data->duration_s);
  duration += hrm_data->duration_t / 10.0;
  
  kp_workout_set_duration_in_milliseconds (wo, duration * 1000);
  
  return wo;
}
*/

KP_PLUGIN_INIT("S410", init_plugin, info)

