/*
 *
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "framedisplayer.h"
#include "preferences.h"
#include "libdv.h"
#include "frame.h"

#include <iostream>

#include <pthread.h>

using std::cout;
using std::cerr;
using std::endl;

FrameDisplayer::FrameDisplayer(): displayer(NULL), audio_device_avail(FALSE)
{
    Preferences &prefs = Preferences::getInstance();
    if (prefs.enableAudio) audio_device = dv_oss_new();
    for(gint i=0; i < 4; i++)
        audio_buffers[i] = (gint16 *) malloc(DV_AUDIO_MAX_SAMPLES*sizeof(gint16));
}


FrameDisplayer::~FrameDisplayer()
{
	if ( displayer != NULL )
		delete displayer;

    if (audio_device_avail) {
        dv_oss_close(audio_device);
        audio_device_avail = FALSE;
        audio_device = NULL;
    }
    for(gint i=0; i < 4; i++) free( audio_buffers[i]);
}

static unsigned char *buffer[ 10240 ];

void FrameDisplayer::PutSound( Frame &frame)
{
    static Preferences &prefs = Preferences::getInstance();
//	static int init = 0;

	if ( prefs.audioRendering == 0 ) {
    	if (prefs.enableAudio && audio_device != NULL) {
        	if (LibDV::DV_decode_full_audio(frame.decoder, frame.data, audio_buffers)) {
            	if (!audio_device_avail &&
               		dv_oss_init(frame.decoder->audio, audio_device))
                   		audio_device_avail = TRUE;
            	if (audio_device_avail)
        	    	dv_oss_play(frame.decoder->audio, audio_device, audio_buffers);
    		}
    	}
	}
	else if ( prefs.audioRendering == 1 ) {
    	if (prefs.enableAudio && audio_device != NULL) {
			//cout << "size = " << size << endl;
			if ( !audio_device_avail &&
        	 	dv_oss_init(frame.decoder->audio, audio_device))
        		audio_device_avail = TRUE;
			int size = frame.ExtractAudio( buffer );
        	if (audio_device_avail)
				dv_oss_player( audio_device, buffer, size );
		}
	}
}

void FrameDisplayer::Put(Frame &frame, GtkWidget *drawingarea, gboolean no_audio)
{
    static Preferences &prefs = Preferences::getInstance();

	frame.ExtractHeader();
	if ( displayer == NULL ) 
		displayer = FindDisplayer::getDisplayer( drawingarea, frame );

	DisplayerInput input = DISPLAY_NONE;
	switch( displayer->format() ) {
		case DISPLAY_YUV:
			frame.ExtractYUV( pixels );
			input = DISPLAY_YUV;
			break;
		case DISPLAY_RGB:
			frame.ExtractRGB( pixels );
			input = DISPLAY_RGB;
			break;
	}

    if (!no_audio) PutSound(frame);

	displayer->put( input, pixels, frame.decoder->width, frame.decoder->height );
}

