/*
 * export.h Export Mode Base Object
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _EXPORT_H
#define _EXPORT_H

#include <gnome.h>

#include "page_export.h"

extern "C" {
#include "support.h"
}

/** Export mode enumeration

    This assigns each export mode an identifier that can be used as arguments
    for certain methods.
*/    
typedef enum export_mode {
	EXPORT_MODE_1394,
	EXPORT_MODE_AVI,
	EXPORT_MODE_STILLS,
	EXPORT_MODE_AUDIO
};


/** An Export reflects the interaction between the PageExport object and an
	individual export notebook page. All subsequent Export objects must extend this 
	class (publicly) and rewrite any or all of the virtual methods provided.
*/

class Export {
	public:
		PageExport			*exportPage;
		GtkToggleButton		*recordButton;
		GtkToggleButton		*stopButton;

		virtual gulong activate() { return 0; }
		virtual gulong deactivate() { return 0; }
		virtual void start() { }
		virtual void clean() { }
		virtual void startExport() { }
		virtual void stopExport() { }
		virtual void selectScene( int ) { }
};

#endif
