/***************************************************************************
                             pluginpriorityimp.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef PLUGINPRIORITYIMP_H
#define PLUGINPRIORITYIMP_H

#include <pluginpriority.h>
#include <qlist.h>
#include "kinkattaplugin.h"

/**
 * PluginPriority allows for the manipulation of the plugin's priorities. 
 * You can change what plugin gets first dibs on messages when being
 * sent out/in etc.
 * @author Benjamin Meyer
 */

class PluginPriorityImp : public PluginPriority  {

Q_OBJECT
	
signals:
  /// Once the Ok button is clicked to send out the new list. 
  void setPluginList( QList<KinkattaPlugin> plugins );

public:
  /// Constructor
  PluginPriorityImp( QWidget *parent=0, const char *name=0 );

  /// Deconstructor
  ~PluginPriorityImp();

  /// Set the list of plugins to manipulate.
  void setPlugins( QList<KinkattaPlugin> &plugins );

private slots:
  /// Move up the priority of a plugin.
  void upClicked();

  /// Move down the priority of a plugin.
  void downClicked();

  /// Set the new list.
  void okClicked();

private:
  /// Loads the list into the widget.
  void loadList();

  /// The list of plugins.
  QList<KinkattaPlugin> plugins;

};

#endif

// PluginPriorityImp.h

