/***************************************************************************
                             awayschedule.cpp 
                           -------------------
    begin                : Saturday Dev 1 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "awayschedule.h"
#include "configure.h"
#include "chat.h"
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtimer.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <qpushbutton.h>
#include <qdatetime.h>
#include "appointmentimp.h"
#include "preferences.h"
#include <qdir.h>

#include "buddylistwindow.h"

#define TIME_TO_CHECK_IN_SECONDS 10

extern "C"
{
  void* create_plugin()
  {
    return new AwaySchedule;
  }
};

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
AwaySchedule::AwaySchedule(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.Name = "Away Schedule";
  info.Author = "Benjamin Meyer";
  info.Version = "0.05";
  info.HomePage = "http://kinkatta.sourceforge.net/";
  configureWidget = NULL;
}

/**
 * Does nothing.
 */
AwaySchedule::~AwaySchedule(){
}

/**
 * Reads in the settings. Starts the clock.
 */
void AwaySchedule::initPlugin(){
  // Read Settings.
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/awaySchedule.settings" ;
  Preferences prefs(DirStr, info.Name, info.Version);

  prefs.setGroup("messages");
  int messageCount = prefs.getNumber("message_count");

  for(int i = 0; i < messageCount; i++){
    appointment *a = new appointment();
    a->startHour = prefs.getNumber((QString("message_%1_").arg(i) + "startHour"), 0 );
    a->startMinute = prefs.getNumber((QString("message_%1_").arg(i) + "startMinute"), 0 );
    a->endHour = prefs.getNumber((QString("message_%1_").arg(i) + "endHour"), 0 );
    a->endMinute = prefs.getNumber((QString("message_%1_").arg(i) + "endMinute"), 0 );
    a->message = prefs.getString((QString("message_%1_").arg(i) + "message"), "" );
    appointments.append(a);
  }
  
  // StartClock
  QTimer::singleShot(  TIME_TO_CHECK_IN_SECONDS*1000, this, SLOT(checkToSeeIfWeShouldGoAway()));
}

/**
 * Checks to see if there is a away message that we should put up right now.
 * Once done starts a new clock.
 */
void AwaySchedule::checkToSeeIfWeShouldGoAway(){
  QDate d = QDate::currentDate();
  int day = d.dayOfWeek()-1;
  QTime t = QTime::currentTime(); 

  appointment *a = appointments.first();
  while( a ){
    if( a->day == day ){
      if( a->startHour <= t.hour() && a->endHour >= t.hour() ){
        bool found = true;
	if( a->startHour == t.hour() ){
	  if( a->startMinute <= t.minute() )
	    found = true;
	  else
	    found = false;   
	}  
        if( found == true ){
	  if( a->endHour == t.hour() ){
	    if( a->endMinute >= t.minute() )
	      found = true;
	    else
	      found = false;
	  }  
	  if( found == true ){  
	    if(!onLine()) {
	      // We are not online
	      break;
	    }
	    else{
	      qDebug("We found it within the hour time.");
	      if( enabled )
                setAwayNow(a->message);
	      break;
	    }
	  }
	}
      }
    }
    a = appointments.next();
  }
 QTimer::singleShot(  TIME_TO_CHECK_IN_SECONDS*1000, this, SLOT(checkToSeeIfWeShouldGoAway()));

}
 
/**
 * Gets the current value of the settings from the configure widget.
 */
void AwaySchedule::applyConfigure(){
  qDebug("Updating Configure");
  if( configureWidget != NULL ) {
    enabled = configureWidget->checkboxEnabled->isChecked();
  }
}

/**
 * Creates the configure widget if there isn't one.
 * @param parent the parent widget for the configure widget if one needs to be made.
 * @return QWidget the configure widget for this plugin.
 */
QWidget *AwaySchedule::configure( QWidget *parent ){
  if ( configureWidget == NULL ){
    configureWidget = new Configure(parent, "Rot13 Configure window.");
    connect(configureWidget->add, SIGNAL(clicked()), this, SLOT(addAppointment()));
    connect(configureWidget->edit, SIGNAL(clicked()), this, SLOT(editAppointment()));
    connect(configureWidget->remove, SIGNAL(clicked()), this, SLOT(removeAppointment()));
    connect(configureWidget->day, SIGNAL(activated(int)), this,
    SLOT(updateDay(int)));
  }
  configureWidget->checkboxEnabled->setChecked(enabled);
  return configureWidget;
}	

/**
 * Opens a new empty edit window.
 */
void AwaySchedule::addAppointment(){
  AppointmentImp *a = new AppointmentImp(configureWidget, "New Appointment");
  appointment *app = new appointment();
  app->day = -1;
  app->startHour = 12;
  app->endHour = 13;
  app->startMinute = 0;
  app->endMinute = 0;
  appointments.append(app);
  a->setAppointment( app );
  connect(a, SIGNAL(updateAppointment( appointment * )), this, SLOT(
    updateAppointment( appointment * )));
  connect(a, SIGNAL(cancelAppointment( appointment * )), this, SLOT(
    cancelAppointment( appointment * )));  
  a->show();
}

/**
 * Removes the currently selected appointment.
 */ 
void AwaySchedule::removeAppointment(){
  appointment *app = findCurrentAppointment();
  if( app == NULL ){
  
  }
  else{
     appointments.remove( app );
     configureWidget->time->removeItem( configureWidget->time->currentItem() );
  }
}

/**
 * Edit the currently selected appointment.
 */
void AwaySchedule::editAppointment(){
  AppointmentImp *a = new AppointmentImp(configureWidget, "New Appointment");
  appointment *app = findCurrentAppointment();
  a->setAppointment( app );
  connect(a, SIGNAL(updateAppointment( appointment * )), this, SLOT(
    updateAppointment( appointment * )));
  connect(a, SIGNAL(cancelAppointment( appointment * )), this, SLOT(
    cancelAppointment( appointment * )));  
  a->show();
}

/**
 * If the appointment was an add then delete it.
 * @param a the appointment.
 */
void AwaySchedule::cancelAppointment( appointment *a ){
  if( a->day == -1){
    appointments.remove(a);
    delete a;
  }
}

/**
 * If the appointment is new set the day and then call updateDay
 * @param appointment the appointment that is being updated.
 */
void AwaySchedule::updateAppointment( appointment *a ){
  if( a->day == -1 ){
    a->day = configureWidget->day->currentItem(); 
  }
  configureWidget->time->clear();
  a = appointments.first();
  while( a ){
    if( a->day == configureWidget->day->currentItem() ){
      QString temp = QString( "%1:%2->%3:%4" ).arg( a->startHour ).arg(
      a->startMinute ).arg( a->endHour ).arg( a->endMinute );
      configureWidget->time->insertItem(temp);
    }
    a = appointments.next();
  }
}

/** 
 * Clear the list of appointments and fill them with today's
 * @param day today's day.
 */
void AwaySchedule::updateDay( int day ){
  configureWidget->time->clear();
  appointment *a = appointments.first();
  while( a ){
    if( a->day == day ){
      QString temp = QString( "%1:%2->%3:%4" ).arg( a->startHour ).arg(
      a->startMinute ).arg( a->endHour ).arg( a->endMinute );
      configureWidget->time->insertItem(temp);
    }
    a = appointments.next();
  }
}

/**
 * Find the current appointment that is selected in the list.
 * @return the current appointment. NULL if unknown.
 */
appointment *AwaySchedule::findCurrentAppointment(){
  appointment *a = appointments.first();
  while( a ){
    if( a->day == configureWidget->day->currentItem() ){
      QString temp = QString( "%1:%2->%3:%4" ).arg( a->startHour ).arg(
      a->startMinute ).arg( a->endHour ).arg( a->endMinute );
      if( temp == configureWidget->time->currentText() )
        break;
    }
    a = appointments.next();
  }
  return a;
}


/**
 * Save all of the appointments to file.
 */
void AwaySchedule::saveSettings(){
  QString DirStr = QDir::homeDirPath() + "/.kinkatta/plugins/awaySchedule.settings" ;
  QFile::remove(DirStr);
  Preferences prefs(DirStr, info.Name, info.Version);
  prefs.setGroup("awayMessages");
  int i = 0;
  appointment *a = appointments.first();
  while( a ){  
    prefs.setNumber(QString("message_%1_").arg(i) + "startHour", a->startHour);
    prefs.setNumber(QString("message_%1_").arg(i) + "startMinute", a->startMinute);
    prefs.setNumber(QString("message_%1_").arg(i) + "endHour", a->endHour);
    prefs.setNumber(QString("message_%1_").arg(i) + "endMinute", a->endMinute);
    prefs.setString(QString("message_%1_").arg(i) + "message", a->message);
    a = appointments.next();
    i++;
  } 
  prefs.setNumber("message_count", i);
  prefs.flush();
}

// appointment.cpp

