/***************************************************************************
																info.cpp
													-------------------
		begin								: Mon Jul 31 2000
		copyright						: (C) 2000 by Benjamin Meyer
		email								: benjamin@csh.rit.edu
 ***************************************************************************/

#include "info.h"
#include "application.h"
#include <kapplication.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qfileinfo.h>
#include "kinkattatextbrowser.h"
#include <qpushbutton.h>
#include <kapp.h>
#include <qdatetime.h>
#include <kio/jobclasses.h>
#include <ktempfile.h>
#include <qregexp.h>

/**
 * Initializes the dialog and does signal-slot connection.
 * @param parent the parent widget
 * @param name the name of this widget
 */
Info::Info(QWidget *parent, const char *name) 
  : KDialog(parent,name,false,WDestructiveClose){
	initDialog();
	connect(Close, SIGNAL(clicked()), this, SLOT(closeWindow()));
	user = "";
}

/**
 * Close out the window.
 * @param e the close event
 */
void Info::closeEvent(QCloseEvent *) {
	// Close window
	this->done(1);
}

/**
 * Get the page from the web using kio::copyjob (asynchronous)
 * @param data the URL to retrieve from
 */
void Info::addToWindow(QString data){
	KTempFile tempFile(QString("kinkatta-info"));
	QFileInfo fi( *tempFile.file() );
	//qDebug("data %s t \n%s\n", data.latin1(), fi.absFilePath().latin1());

	KURL source(data);
	KURL dest(fi.absFilePath());

	KApplication::setOverrideCursor(Qt::waitCursor);
	KIO::FileCopyJob *copyJob = new KIO::FileCopyJob(source, dest, 664, FALSE, TRUE, FALSE, FALSE);
	connect(copyJob, SIGNAL(result(KIO::Job*)), this, SLOT(copyJobResult(KIO::Job*)));
}

/**
 * Copies the data from the KIO Job.  Uses this data to fill in the
 * information dialog.
 * @param job the IO job to copy from
 */
void Info::copyJobResult(KIO::Job *job){
	//qDebug("Info::copyJobResult");
	KIO::FileCopyJob *copyJob = dynamic_cast<KIO::FileCopyJob*> (job);
	KApplication::restoreOverrideCursor();

	if ( copyJob->error() == 0 ){
		KURL kurl = copyJob->destURL();
		//qDebug("kurl %s\n", (kurl.path() + kurl.filename()).latin1());

		QFile file(kurl.path());

		QString info = "<qt>";
		if (file.open(IO_ReadOnly))
		{
			QTextStream stream(&file);
			while(!stream.eof()){
				info += stream.readLine();
				info += "\n";
			}
			file.close();
			file.remove();

			
			int titleEnd = info.find("</TITLE>");
			info = info.mid(titleEnd + 14, info.length() -14);
			info = QString("<html>") + info; 
			info.replace( QRegExp("free_icon.gif"), DATADIR "/pics/buddy_oscar.png" "\" width=\"16\" height=\"16" );
			info.replace( QRegExp("aol_icon.gif"), DATADIR "/pics/buddy_aol.png" "\" width=\"16\" height=\"16" );
			info.replace( QRegExp("admin_icon.gif"), DATADIR "/pics/buddy_admin.png" "\" width=\"16\" height=\"16" );
			// remove trial user info
			info.replace( QRegExp("<IMG SRC=\"dt_icon.gif\">"), " " );
			info.replace( QRegExp(": Trial AIM User <br>"), "");
			
			// Replace special options.
			QString currentDate = QDate::currentDate().toString();
			QString currentTime = QTime::currentTime().toString();
			info.replace( QRegExp("%d"), currentDate );
			info.replace( QRegExp("%t"), currentTime );
			info.replace( QRegExp("%n"), user );
			
			Information->setText(info);
		}
	}
  else{
    copyJob->showErrorDialog(this);
    QFile file( (copyJob->destURL()).path());
    file.remove();
  }
}

/**
 * Resize the window.  Initialize the Information class.  Connect
 * slots for the Information class and the Close button.
 */
void  Info::initDialog(){
  this->resize(450,450);
  this->setMinimumSize(300,190);
  Information= new KinkattaTextBrowser(this,"NoName", true);
  Information->setGeometry(10,10,280,240);
  Information->setMinimumSize(0,0);
  Information->setText("Downloading...");
  connect(Information, SIGNAL(urlClick(const QString &)), KApplication::kApplication(), SLOT( invokeBrowser(const QString &)));
  connect(Information, SIGNAL(mailClick( const QString &, const QString &)), this, SLOT(mailToClicked(const QString &, const QString &)));

  Close= new QPushButton(this,"NoName");
  Close->setGeometry(190,260,100,30);
  Close->setMinimumSize(0,0);
  Close->setText("&Close");
}

/**
 * Close the window once the close button is hit. 
 */
void Info::closeWindow(){
	this->done(1);
}

/*
 * Resizes the object in the window, when the window is resized.
 * @param e the resize event
 */
void Info::resizeEvent( QResizeEvent * ){
	Information->setGeometry(10,10,this->width()-20,this->height()-60);
	Close->setGeometry(this->width()-110,this->height()-40,100,30);
}

/**
 * Open this URL in the system mail editor.
 * @param name the name of the person to mail (!!!not used!!!)
 * @param address the address to send mail to
 */
void Info::mailToClicked(const QString &name, const QString &address){
	kapp->invokeMailer( address, QString::null );
}

// info.cpp
#include "info.moc"

