/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 *  $Id: diskmgtapi.c,v 1.8 2000/09/13 19:39:03 burke Exp $
 *
 *  Copyright (C) 2000 Mission Critical Linux, LLC
 *
 *  author: Tim Burke <burke@missioncriticallinux.com>
 *  description: Management configuration interfaces.
 *
 * This file implements a set of interfaces used by "management" utilities
 * to interact with the disk subsystem.
 */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>
#include <msgsvc.h>
#include <clucfg.h>

#include <logger.h>
#include <sys/syslog.h>
#include <parseconf.h>
#include "diskstate.h"
#include "disk_proto.h"

static const char *version __attribute__ ((unused)) = "$Id: diskmgtapi.c,v 1.8 2000/09/13 19:39:03 burke Exp $";
static int myNodeNumber = -1;

/*
 * Configuration description of the device special file(s)
 * representing a node's shared state partition.
 */
typedef struct {
	int id;	
	char primaryPartition[MAXPATHLEN];
	char backupPartition[MAXPATHLEN];
} SharedDiskDescriptor;

/*
 * Sets a node's disk descriptor.
 * Returns: 0 - success
 *	    -1 - failure, errno set to:
 *		 EINVAL - invalid parameter (id, or filename does not
 *			  describe a device special file).
 *		 EIO - unable to write to configuration database
 * Notes: This can only be safely be called while the cluster is stopped
 *	  (i.e. the quorumd is not running).  If the values are modified in
 *	  the configuration database while the quorumd is running the new
 *	  partitions will not be used until the quorumd is restarted.
 */
int cluSetDiskDescriptor(void) {/*SharedDiskDescriptor *diskDesc)*/
    clulog(LOG_ERR, "cluSetDiskDescriptor: not yet implemented.\n");
    return(0);
}

/*
 * Retrieve the filenames of the partitions used for shared cluster
 * state on a specified node.  On success the results populate the 
 * passed data structure.
 * Returns: 0 - success
 *	   -1 - failure, errno set to:
 *		 EINVAL - invalid parameter (id)
 *		 EIO - unable to read configuration database
 *		 ENODEV - configuration unspecified (i.e. no corresponding
 *			  cluSetDiskDescriptor has been issued).
 */
int cluGetDiskDescriptor(void) { /*int id, SharedDiskDescriptor *diskDesc)*/
    clulog(LOG_ERR, "cluGetDiskDescriptor: not yet implemented.\n");
    return(0);
}

/*
 * Retrieve the node status of all cluster members.  On success the results 
 * populate the passed data structure.
 * Returns: 0 - success
 *	   -1 - failure, errno set to:
 *		 EIO - unable to get the status information from the
 *		       quorum daemon.
 */
int cluGetDiskNodeStates(SharedDiskNodeStates *nodeStates) {
    msg_handle_t        con;
    DiskMessageSt       sendMsgBuf;
    int                 auth = 0;

    if (myNodeNumber == -1) {
	myNodeNumber = cluGetLocalNodeId();
	if (myNodeNumber == -1) {
#ifdef DEBUG
            perror("cluGetLocalNodeId");
#endif
            return(-1);
	}
    }
    con = msg_open(PROCID_QUORUMD, myNodeNumber);
    if (con < 0) {
        return(-1);
    } else {

	sendMsgBuf.hdr.magic = GENERIC_HDR_MAGIC;
	sendMsgBuf.hdr.command = DISK_NODE_STATES;
        if (msg_send(con, &sendMsgBuf, DISK_MESSAGE_SIZE) < 0) {
	    msg_close(con);
            return(-1);
        } else {
            if ((msg_receive_timeout(con, &sendMsgBuf, DISK_MESSAGE_SIZE, 
				     &auth, 5))	< (int)DISK_MESSAGE_SIZE) {
	        msg_close(con);
                return(-1);
	    }
	    nodeStates->states[0] = sendMsgBuf.data.nodeStates.states[0];
	    nodeStates->states[1] = sendMsgBuf.data.nodeStates.states[1];
        }                                                                           }                   
    msg_close(con);
    return(0);
}

/*
 * API used to notify quorumd of a configuration change.  
 * In responst to this quorumd will notify the daemons on the local node to
 * re-read configuration settings.  Additionally quorumd will perform a
 * disk-based operation which will trigger the other cluster member to
 * also update configuration settings.
 * Returns: 0 - success
 *	   -1 - failure
 */
int cluConfigChangeNotification(void) {
    msg_handle_t        con;
    DiskMessageSt sendMsgBuf;

    if (myNodeNumber == -1) {
	myNodeNumber = cluGetLocalNodeId();
	if (myNodeNumber == -1) {
#ifdef DEBUG
            perror("cluGetLocalNodeId");
#endif
            return(-1);
	}
    }
    con = msg_open(PROCID_QUORUMD, myNodeNumber);
    if (con < 0) {
        return(-1);
    } else {

	sendMsgBuf.hdr.magic = GENERIC_HDR_MAGIC;
	sendMsgBuf.hdr.command = DISK_CONFIG_CHANGE;
        if (msg_send(con, &sendMsgBuf, DISK_MESSAGE_SIZE) < 0) {
	    msg_close(con);
            return(-1);
        } 
    }                   
    msg_close(con);
    return(0);
}

/*
 * Initialize shared state disk partitions.
 * (Refer to detailed notes above.)
 * Returns: 0 - success
 *	   -1 - error, errno set to:
 *		EINVAL - the disk partitions have not yet been specified.
 *		EBUSY - can't initialize because the quorumd is running.
 *		EIO   - unable to access shared state disk partitions.
 */
int cluInitDiskPartitions(void) {
    clulog(LOG_ERR, "cluInitDiskPartitions: not yet implemented.\n");
    return(0);
}

/*
 * Verification check of the shared state disk partitions.
 * (Refer to detailed notes above.)
 * Returns: 0 - success
 *	   -1 - error, errno set to:
 *		EINVAL - the disk partitions have not yet been specified.
 *		EIO   - unable to access shared state disk partitions.
 */
int cluVerifyDiskPartitions(void) {
    clulog(LOG_ERR, "cluVerifyDiskPartitions: not yet implemented.\n");
    return(0);
}


