/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/

#ifdef __cplusplus
extern "C" {
#endif
      

#include <sys/types.h>
#include <diskstate.h>
/*
 * Function prototype definitions used to describe the APIs within the
 * disk related modules.
 * Author: Tim Burke <burke@missioncriticallinux.com>
 * $Revision: 1.9 $
 */

/*
 * --- The following is the disk service state API ----
 */
int readStatusBlock(off_t offsetStatus, NodeStatusBlock *statb, int aligned);
int writeStatusBlock(off_t writeOffset, NodeStatusBlock *statBlock, int aligned);
void printPartnerStatus(int);
void printStatusBlock(NodeStatusBlock *, char *);
void printStatusBlocks(int);
int initializePartitionServiceState(void);
/*-------- end service state API ------------*/           
/*
 * --- The following is the Raw IO API ----
 */
char * allocAlignedBuf(void);
int freeAlignedBuf(char *buf);
void printRawIOStats(void);
int initAlignedBufStuff(void);
int deinitAlignedBufStuff(void);
int diskRawRead(int fd, char *buf, int len);
int diskRawWrite(int fd, char *buf, int len);
int diskRawReadShadow(off_t readOffset, char *buf, int len, ulong chksum_off, int repair_ok);
int diskRawWriteShadow(off_t writeOffset, char *buf, int len, ulong chksum_off);
int diskLseekRawReadChecksum(int partition, off_t readOffset, char *buf, int len, ulong chksum_off);
/*-------- end service Raw IO API ------------*/           
/*
 * --- The following is the Disk Services API ----
 */
int initServiceSubsys(void);
int closeServiceSubsys(void);
int getServiceStatus(int svcNum, ServiceBlock *svcblk);
int setServiceStatus(ServiceBlock *svcblk);
int removeService(int svcNum);
void printServiceList(void);
int initializePartitionServiceBlocks(void);
int readAllServiceBlocks(void);
/*-------- end service Disk Services API ------------*/           
/*
 * --- The following is the Disk Lock API ----
 */
int initLockSubsys(void);
int closeLockSubsys(void);
void initLockBlock(DiskLockBlock *);
void printLockBlocks(void);
void printBothLockBlocks(int);
int initializePartitionLockBlocks(void);
int lockClear(int nodeNum);
int lockWrite(int nodeNum, DiskLockBlock *lock_block);
int lockRead(int nodeNum, DiskLockBlock *lock_block);

/*-------- end service Disk Lock API ------------*/           
/*
 * --- The following is the disk utilities API ----
 */
int initSharedFD(void);
int openPartition(char *name);
int closePartition(int *fd);
int getPartitionName(int which, char *name);
int readHeader(SharedStateHeader *hdr);
int readHeaderNoshaddowUnlocked(SharedStateHeader *hdr);
int writeHeader(SharedStateHeader *hdr);
void printSharedStateHeader(SharedStateHeader *hdr);
int offsetParanoiaCheck(void);
int getVerboseLevel(void);
int validatePartitionName(char *name);
int initializePartition(int prompt);
void shut_myself_down(char *reason);
int consider_shutdown(char *reason);
int cluster_member_check(void);
/*-------- end disk utilities API ------------*/           
/*
 * --- The following is API to access the on-disk configuration "database" ---
 */
ssize_t getDatabaseLength(void);
ulong getDatabaseChecksum(void);
ssize_t writeDatabase(char *data, ssize_t length);
ssize_t readDatabase(char *data, ssize_t max_length);
int initializeConfigDatabase(void);
int readScanWholeDatabase(void);
/*-------- end configuration database API ------------*/           
/*
 * --- The following is API to access the on-disk net block ---
 */
int initializePartitionNetBlock(void);
int readRepairNetBlock(void);
int getNetBlockData(char *netBlockData);
int setNetBlockData(char *netBlockData);
/*-------- end net block API ------------*/           
/*
 * --- The following is the Quorum Daemon API ----
 * XXX - these are candidates for removal
 */
void printQuorumStats(void);
int startQuorumd(int interactive);
int stopQuorumd(int complain, int clean, int fromDaemon);
int getNodeState(int nodeNum);
/*-------- end Quorum Daemon API ------------*/ 
/*
 * --- The following is API to locking audits ---
 */
int clu_write_checksum(char *alignedBuf, int len, ulong chksum_off);         
int clu_check_checksum(char *alignedBuf, int len, ulong chksum_off);
ulong clu_long_check_sum(ulong *start, int num_longs);
ulong clu_byte_check_sum(char *start, int bytes);
void clu_lock_held_check(void);
/*-------- end locking audits API ------------*/ 
/*
 * --- The following is API to the disk scanning facility ---
 */
void scanWholeDisk(void);
void scanNextCategory(int delaySecs);
/*-------- end disk scan API ------------*/ 
    
#ifdef __cplusplus
}
#endif
	
