\ pfex.4th
\
\ Annotated example of using the polynomial fitting routine
\ under kforth.
\
\ K. Myneni, 5-10-2000
\

\ First load the necessary source files

include matrix
include polyfit

\ Now create the x and y matrices (floating pt) to hold
\   the data to be fitted. We will allocate 1024 x 1 matrices
\   but the matrices can be set to a lesser size depending
\   on how many points we actually have.

create x 1024 dfloats 8 + allot
create y 1024 dfloats 8 + allot

\ Let's set the size of the x and y matrices to 10 x 1 for
\   this example.

10 1 x mat_size!
10 1 y mat_size!

\ Let's manually put in 10 values into the x and y arrays now.
\   I will use the data for y = x^2

0e  1e  2e  3e  4e  5e  6e  7e  8e  9e  10 1 x fcol!
0e  1e  4e  9e 16e 25e 36e 49e 64e 81e  10 1 y fcol!

\ You can verify that the x and y matrices have the correct
\   data in them by printing them out, e.g.
\
\	x fmat.
\	y fmat.


\ We also need an array to hold the fitted polynomial coefficients.

create coeffs 10 dfloats 8 + allot


\ Now fit the data to a 2nd order polynomial, and print 
\   chi-square and the coefficients

x y coeffs 2 polfit

." Chi-square = " f. cr
." The coefficients are: " cr cr
coeffs fmat.


