
\ anew __get-line__

\ GET-LINE - A safe way to read text files
\
\ Bill McCarthy <WJMc@pobox.com>
\
\ Although READ-LINE is a useful primitive, it shouldn't
\ appear in a program without a wrapper.  An unanticipated
\ long input line could cause serious problems.
\
\ This wrapper reads an entire line.  It stores the 'len'
\ specified in your buffer.  Any additional data on the line
\ is ignored but the number of ignored characters are
\ reported.  The return values not-eof-flag and ior have the
\ same meaning as in READ-LINE.

\ kForth requires the following files:
\
\	strings.4th
\	files.4th
\
\ Revisions:
\
\	2003-02-18  fixed problem with list-file not closing input file  km

500 constant gl-bufsz

create gl-buf gl-bufsz 2 + allot

: get-line ( buf len fid -- read ignored not-eof-flag ior )
    >r tuck r@ read-line                ( len got flag ior ) ( r: fid )
    ?dup
    if r> drop >r drop 2drop 0 0 0 r> exit      \ return read-line error
    then 0=
    if r> drop 2drop 0 0 0 0 exit       \ if was at eof, return that status
    then tuck >                         ( got len>got ) ( r: fid )
    if r> drop 0 -1 0 exit              \ we're done
    then 0                              ( read 0 ) ( r: fid )
    \ Now read the rest of the line
    begin
        gl-buf gl-bufsz r@ read-line    ( read ignored got -1 ior ) ( r: fid )
        ?dup
        if r> drop >r 2drop 2drop
            0 0 0 r> exit               \ return read-line error
        then drop tuck + swap           ( read ignored' got ) ( r: fid )
        gl-bufsz <
    until r> drop -1 0 ;

\ Simple Test
\
\ Read a text file listing the first 'n' characters and
\ reporting the number of characters ignored on each line.

create tbuf 72 allot

: list-file ( addr u n -- )  \ Usage:  s" filename" 10 list-file
    dup 70 > abort" Sorry, not more than 70 characters"
    -rot r/o open-file ( throw) drop  >r ( n ) ( r: fid )
    begin
        tbuf over r@ get-line ( throw) drop ( n read ignored flag ) ( r: fid )
    while
        >r tbuf over cr type ( n read ) ( r: fid ignored )
        over swap - 1+ spaces r> . ( n ) ( r: fid )
    repeat r> close-file 2drop 2drop ;

