/***********************************************************************
**
**   flightdataprint.h
**
**   This file is part of KFLog2.
**
************************************************************************
**
**   Copyright (c):  2002 by Heiner Lamprecht
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: flightdataprint.h,v 1.5 2003/05/20 09:56:19 helmut Exp $
**
***********************************************************************/

#ifndef FLIGHTDATAPRINT_H
#define FLIGHTDATAPRINT_H

#include <qpainter.h>

#include "flight.h"

/**
 * @author Heiner Lamprecht
 * @version $Id: flightdataprint.h,v 1.5 2003/05/20 09:56:19 helmut Exp $
 */
class FlightDataPrint
{
  public:
    /** */
    FlightDataPrint(Flight* currentFlight);
    /** */
    ~FlightDataPrint();

 private:
  /** */
  void __printPositionData(QPainter* painter, flightPoint* cPoint,
          int yPos, const char* text, bool printVario = false,
          bool printSpeed = false);
  /** */
  void __printPositionData(QPainter* painter, Waypoint* cPoint,
          int yPos);
  unsigned int time;
  unsigned int lasttime;
};

#endif
