// -*- c++ -*-
/***************************************************************************
                           kdetvcpudetection.h
                           -------------------
    begin                : Sat Jul 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVCPUDETECTION_H
#define KDETVCPUDETECTION_H

#include <kdemacros.h>
#include "libkdetv_export.h"

// Singleton class
class LIBKDETV_EXPORT KdetvCpuDetection
{
public:
    typedef enum {
        Arch_Unknown,
        Arch_386,
        Arch_X86_64
    } Architecture;

    // Typesafe bitfield
    typedef enum {
        Cap_Unknown = 0,
        Cap_MMX     = (1 << 0),
        Cap_3DNOW   = (1 << 1),
        Cap_SSE     = (1 << 2),
        Cap_SSE2    = (1 << 3)
    } Capabilities;

    static Architecture architecture() { return instance()->_architecture; }
    static Capabilities capabilities() { return instance()->_capabilities; }


private:
    KdetvCpuDetection();
    static KdetvCpuDetection* instance();

    Architecture _architecture;
    Capabilities _capabilities;
};

#endif // KDETVCPUDETECTION_H
