/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include <qlayout.h>

#include <kglobal.h>
#include <klibloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

#include "kdetv.h"
#include "kdetvview.h"
#include "kdetvwidget.h"
#include "kdetvpart.h"

#include "kdetvpanelextension.h"
#include "kdetvpanelextension.moc"

extern "C" KPanelExtension *init( QWidget *parent, const QString& configFile )
{
    KGlobal::locale()->insertCatalogue("kdetvextension");
    KLibLoader::self()->globalLibrary("libkdetv.so");

    return new KdetvExtension( configFile, KPanelExtension::Normal,
                               KPanelExtension::Preferences
                               |KPanelExtension::Help
                               |KPanelExtension::About
                               |KPanelExtension::ReportBug,
                               parent, "kdetvextension" );
}

KdetvExtension::KdetvExtension( const QString &configFile, Type t, int actions,
				QWidget *parent, const char *name )
    : KPanelExtension( configFile, t, actions, parent, name )
{
    tv = new KdetvPart( this, 0, 0, 0, QStringList() );
    screen = tv->widget();
    screen->view()->setFixedSize( 240, 240 );
    screen->setFixedSize( 240, 240 );
}

KdetvExtension::~KdetvExtension()
{

}

void KdetvExtension::showEvent( QShowEvent *se )
{
//    resize( screen->size() );
    updateGeometry();
    KPanelExtension::showEvent( se );
    setFixedSize( 240, 240 );
    resize( 240, 240 );
}

void KdetvExtension::positionChange( Position /* position */)
{
}


QSize KdetvExtension::sizeHint( Position , QSize /* max */) const
{
//    return screen->size();
//    int sz = (max.width() < max.height()) ? max.width() : max.height() ;
    return QSize( 240, 240 );
}

void KdetvExtension::about()
{
    tv->about();
}

void KdetvExtension::help()
{
    tv->help();
}

void KdetvExtension::preferences()
{
    tv->preferences();
}

void KdetvExtension::reportBug()
{
    tv->reportBug();
}
