/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999-2001 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
*/

/*
  $Log: kbgengine.cpp,v $
  Revision 1.1  2001/05/02 19:40:10  hoefkens
  Added the engine directory

  Revision 1.4  2001/03/17 18:55:07  hoefkens
  Oops, __FUNCTION__ not available everywhere

  Revision 1.3  2001/03/16 07:33:50  hoefkens
  Rewrite of the setup dialog. First (not fully working) eventsrc file.

*/

#include <kbgengine.moc>
#include <kbgengine.h>


/*
 * Constructor initializes the QObject
 */
KBgEngine::KBgEngine(QWidget *parent, QString *name, QPopupMenu *pmenu)
	: QObject(parent, name->local8Bit())
{
	menu = pmenu;
	cl = -1;
	ct = new QTimer(this);
	connect(ct, SIGNAL(timeout()), this, SLOT(done()));
}

/*
 * Destructor is empty
 */
KBgEngine::~KBgEngine()
{
	// empty
}

/*
 * Set the length of the commit timeout. Negative values disable the
 * feature.
 */
void KBgEngine::setCommit(const double com)
{
	cl = int(1000*com);
}

// EOF
