//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "sdpneighbourfactory.h"
#include "sdpneighbourinfo.h"
#include <kdebug.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>

#include <termios.h>
#include <fcntl.h>
#include <getopt.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <asm/types.h>
#include <netinet/in.h>

#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>

namespace KBluetooth
{
namespace SDP
{

NeighbourFactory::NeighbourFactory(QObject *parent, const char *name)
        : QObject(parent, name)
{}


NeighbourFactory::~NeighbourFactory()
{}

QPtrList<NeighbourInfo> NeighbourFactory::getNeighbourList(QString /*params*/)
{
    QPtrList<NeighbourInfo> list;

    kdDebug() << "NeighbourQuery::getNeighbourList" << endl;
    updateNeighbours();
    return neighbourList;
}

void NeighbourFactory::updateNeighbours()
{
    QDateTime currentTime = QDateTime::currentDateTime();
    if ((neighbourUpdateTime.isValid()==false) ||
            (neighbourUpdateTime.secsTo(currentTime) > 20))
    {
        // refresh the NeighbourList
        kdDebug() << "Query Neighbours" << neighbourUpdateTime.secsTo(currentTime) << endl;
        queryNeighbours();
    }
    else
    {
        kdDebug() << "neighbourcache age:" << neighbourUpdateTime.secsTo(currentTime) << endl;
    }
}

void NeighbourFactory::queryNeighbours()
{
    neighbourList.clear();

    inquiry_info *info = NULL;
    int dev_id = 0;
    int length = 5;
    int maxNumRsp = 10; // is this the real meaning of this param?
    int flags = 0; // |=IREQ_CACHE_FLUSH
    char name[2048];
    kdDebug() << "looking for bluetooth devices..." << endl;
    int numRsp = hci_inquiry(dev_id, length, maxNumRsp, NULL, &info, flags);
    kdDebug() << numRsp << "devices found.." << endl;
    if (numRsp < 0)
    {
        kdDebug() << "Inquiry failed." << endl;
        return;
    }
    else
    {
        int dd = hci_open_dev(dev_id);
        if (dd < 0)
        {
            kdDebug() << "HCI device open failed" << endl;
            free(info);
            return;
        }
        for (int i = 0; i < numRsp; i++)
        {
            bdaddr_t bdaddr;
            memset(name, 0, sizeof(name));
            if (hci_read_remote_name(dd, &(info+i)->bdaddr, sizeof(name), name, 100000) < 0)
            {
                strcpy(name, "n/a");
            }
            baswap(&bdaddr, &(info+i)->bdaddr);
            NeighbourInfo *info = new NeighbourInfo(this);
            info->addrStr = QString(batostr(&bdaddr));
            info->nameStr = QString(name);
            neighbourList.append(info);
        }
        close(dd);
        free(info);
    }
    neighbourUpdateTime = QDateTime::currentDateTime();
}

}
}

#include "sdpneighbourfactory.moc"
