/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef OBEXCONNECTIONWIZARD_H
#define OBEXCONNECTIONWIZARD_H

#include <kdialogbase.h>

class QGridLayout;
class QTabWidget;
class QPushButton;
class QWidget;
class QLabel;
class QListBox;
class QSpinBox;
class QWidgetStack;
class KRestrictedLine;

class BluetoothDeviceWidget;
class IrDADeviceWidget;
class SerialDeviceWidget;
class IpDeviceWidget;

class Edit : public KDialogBase
{
  Q_OBJECT
public:
  enum {
    SerialConfigurationPage,
    BluetoothConfigurationPage,
    IrDAConfigurationPage,
    IpConfigurationPage
  };

  Edit( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~Edit();

  QString name() const;
  QString transport() const;
  QString device() const;
  QString peer() const;
  int overridePerms() const;
  int ipPort() const;
  int speed() const;
  int disconnectTimeout() const;

public slots:
  void setName( const QString& );
  void setTransport( const QString& );
  void setDevice( const QString& );
  void setPeer( const QString& );
  void setOverridePerms( int );
  void setIpPort( int );
  void setSpeed( int );
  void setDisconnectTimeout( int );

  void slotTransportSelectionChanged();
  void slotCheckConfig();

private:
  // Top widgets
  QGridLayout* mTopLayout;
  QTabWidget* mTabWidget;

  // Tab 1
  QWidget* mGeneralTab;
  QGridLayout* mGeneralTabLayout;
  QLabel* mAliasInputText;
  KRestrictedLine* mAliasInput;
  QLabel* mTransportInputText;
  QListBox* mTransportInputBox;

  // Tab 2
  QWidgetStack* mWidgetStack;
  SerialDeviceWidget* mSerial;
  BluetoothDeviceWidget* mBluetooth;
  IrDADeviceWidget* mIrDA;
  IpDeviceWidget* mIp;

  // Tab 3
  QWidget* mAdvancedTab;
  QGridLayout* mAdvancedTabLayout;
  QLabel* mDisconnectTimeoutText;
  QSpinBox* mDisconnectTimeoutInput;
  QLabel* mOverridePermsText;
  KRestrictedLine* mOverridePermsInput;
};

#endif
