/*
    This file is part of kio_obex.

    Copyright (c) 2003 Mathias Froehlich <Mathias.Froehlich@web.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef DISCOVERABLEDEVICEWIDGET_H
#define DISCOVERABLEDEVICEWIDGET_H

class QString;
class QWidget;
class QVBoxLayout;
class QGridLayout;
class QLabel;
class QButtonGroup;
class QRadioButton;
class QPushButton;
class QListView;
class QListViewItem;
class QLineEdit;
class QRegExp;

class DiscoverableDeviceWidget : public QWidget
{
  Q_OBJECT
public:
  DiscoverableDeviceWidget( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~DiscoverableDeviceWidget();

  QString address() const;

public slots:
  void setAddress( const QString& );
  void checkConfiguration();

protected slots:
  virtual void slotDiscoveryButtonPressed() = 0;
  void slotListViewPressed( QListViewItem * );
  void slotEnableSpecific( bool );

signals:
  void configurationReady( bool );
  
protected:
  virtual QString anyDevice() const = 0;
  void clearDiscoveredDevices();
  void discoveredDevice( const QString&, const QString&, bool = true );

  QRadioButton* mDynamicDiscoveryButton;
  QRadioButton* mSpecificDeviceButton;
  QPushButton* mDiscoverButton;
  QGridLayout* mDiscoveryTransportLayout;
  QButtonGroup* mButtonGroup;
  QVBoxLayout* mButtonGroupLayout;
  QListView* mDiscoveryView;
  QLabel* mHandInputText;
  QLineEdit* mHandInputInput;
};

#endif
