/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "DevicesWindow.h"
#include "devices_icons.h"
#include "DevicesWindow.moc"

#include <qvariant.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qbuttongroup.h>
#include <kmessagebox.h>
#include <kapplication.h>

#include <iostream>
using namespace std;

#include "DevicesWindowHandlers.cpp"

/*
 *  Constructs a DevicesWindow as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 */
DevicesWindow::DevicesWindow( QWidget* parent, const char* name, WFlags fl )
        : QWidget( parent, name, fl ),
    QPixmap_USB( (const char **) USB_data ),
    QPixmap_VHCI( (const char **) VHCI_data ),
    QPixmap_PCCARD( (const char **) PCCARD_data ),
    QPixmap_PCI( (const char **) PCI_data ),
    QPixmap_UNKNOWN( (const char **) UNKNOWN_data )
{
    if ( !name )
        setName( "DevicesWindow" );

    buttongroup_devices = new QButtonGroup( this, "buttongroup_devices" );
    buttongroup_devices->setGeometry( QRect( 15, 10, 180, 140 ) );

    localdevices = new QListBox( buttongroup_devices, "localdevices" );
    localdevices->setGeometry( QRect( 15, 20, 150, 110 ) );
    localdevices->setFrameShadow( QListBox::Sunken );
    localdevices_current_device = -1;

    buttongroup_details = new QButtonGroup( this, "buttongroup_details" );
//    buttongroup_details->setGeometry( QRect( 15, 160, 277, 303 ) );
    buttongroup_details->setGeometry( QRect( 15, 160, 287, 293 ) );

    QWidget* privateLayoutWidget =
        new QWidget(buttongroup_details, "device_specs_layout" );
//    privateLayoutWidget->setGeometry( QRect( 10, 15, 250, 230 ) );
    privateLayoutWidget->setGeometry( QRect( 10, 15, 267, 275 ) );
    device_specs_layout =
        new QGridLayout( privateLayoutWidget,1,1,11,6,"device_specs_layout");

    label_authentication_2 =
        new QLabel( privateLayoutWidget, "label_authentication_2" );
    label_inquiry_scan = new QLabel( privateLayoutWidget,"label_inquiry_scan" );
    label_page_scan = new QLabel( privateLayoutWidget, "label_page_scan" );
    label_authentication =
        new QLabel( privateLayoutWidget, "label_authentication" );
    combo_status = new QComboBox( FALSE, privateLayoutWidget, "combo_status" );
    label_status = new QLabel( privateLayoutWidget, "label_status" );
    label_name = new QLabel( privateLayoutWidget, "label_name" );
    label_bdaddress = new QLabel( privateLayoutWidget, "label_bdaddress" );

    lineedit_bdaddress=new QLineEdit( privateLayoutWidget,"lineedit_bdaddress");
    lineedit_bdaddress->setEnabled( TRUE );
    lineedit_bdaddress->setEdited( FALSE );
    lineedit_bdaddress->setReadOnly( TRUE );

    lineedit_name = new QLineEdit( privateLayoutWidget, "lineedit_name" );
    lineedit_name->setEnabled( TRUE );
    lineedit_name->setEdited( TRUE );
    lineedit_name->setReadOnly( FALSE );

    combo_inquiry_scan_enabled =
      new QComboBox( FALSE, privateLayoutWidget,"combo_inquiry_scan_enabled");
    combo_page_scan_enabled =
      new QComboBox( FALSE, privateLayoutWidget,"combo_page_scan_enabled");
    combo_encryption_enabled =
      new QComboBox( FALSE, privateLayoutWidget,"combo_encryption_enabled");
    combo_authentication_enabled =
      new QComboBox( FALSE, privateLayoutWidget,"combo_authentication_enabled");

    pushbutton_update = new QPushButton( this, "pushbutton_update" );
    pushbutton_update->setGeometry( QRect( 200, 25, 100, 30 ) );
    pushbutton_reset = new QPushButton( this, "pushbutton_reset" );
    pushbutton_reset->setGeometry( QRect( 200, 55, 100, 30 ) );
    pushbutton_show_details = new QPushButton(this, "pushbutton_show_details" );
    pushbutton_show_details->setGeometry( QRect( 200, 85, 100, 30 ) );
    pushbutton_device_class = new QPushButton(this, "pushbutton_device_class" );
    pushbutton_device_class->setGeometry( QRect( 200, 115, 100, 30 ) );


    // layout setup:
    device_specs_layout->addWidget( label_name,                   0, 0 );
    device_specs_layout->addWidget( label_status,                 1, 0 );
    device_specs_layout->addWidget( label_bdaddress,              2, 0 );
    device_specs_layout->addWidget( label_inquiry_scan,           3, 0 );
    device_specs_layout->addWidget( label_page_scan,              4, 0 );
    device_specs_layout->addWidget( label_authentication,         5, 0 );
    device_specs_layout->addWidget( label_authentication_2,       6, 0 );
    device_specs_layout->addWidget( lineedit_name,                0, 1 );
    device_specs_layout->addWidget( combo_status,                 1, 1 );
    device_specs_layout->addWidget( lineedit_bdaddress,           2, 1 );
    device_specs_layout->addWidget( combo_inquiry_scan_enabled,   3, 1 );
    device_specs_layout->addWidget( combo_page_scan_enabled,      4, 1 );
    device_specs_layout->addWidget( combo_authentication_enabled, 5, 1 );
    device_specs_layout->addWidget( combo_encryption_enabled,     6, 1 );

    languageChange();
//    setFixedSize( QSize(305, 435).expandedTo(minimumSizeHint()) );
    setFixedSize( QSize(315, 475).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( localdevices, SIGNAL( selectionChanged(QListBoxItem*) ),
             this, SLOT( localdevices_selectionChanged(QListBoxItem*) ) );
    connect( pushbutton_update, SIGNAL(clicked()),
             this, SLOT(pushbutton_update_clicked()));
    connect( pushbutton_reset, SIGNAL(clicked()),
             this, SLOT(pushbutton_reset_clicked()));
    connect( pushbutton_show_details, SIGNAL(clicked()),
             this, SLOT(pushbutton_show_details_clicked()));
    connect( pushbutton_device_class, SIGNAL(clicked()),
             this, SLOT(pushbutton_show_device_class_window()));
    connect( combo_status, SIGNAL( activated(int) ),
             this, SLOT( combo_status_activated(int) ) );
    connect( combo_inquiry_scan_enabled, SIGNAL( activated(int) ),
             this, SLOT( combo_inquiry_or_page_scan_activated(int) ) );
    connect( combo_page_scan_enabled, SIGNAL( activated(int) ),
             this, SLOT( combo_inquiry_or_page_scan_activated(int) ) );
    connect( combo_authentication_enabled, SIGNAL( activated(int) ),
             this, SLOT( combo_authentication_activated(int) ) );
    connect( combo_encryption_enabled, SIGNAL( activated(int) ),
             this, SLOT( combo_encryption_activated(int) ) );
    connect( lineedit_name, SIGNAL( lostFocus() ),
             this, SLOT( lineedit_name_lost_focus() ) );
    connect( lineedit_name, SIGNAL( returnPressed() ),
             this, SLOT( lineedit_name_return_pressed() ) );

    windowContentUpdate();
    setEnabled(FALSE);
}

void DevicesWindow::windowContentUpdate()
{
    cout << "windowContentUpdate()" << endl;
    localdevices->clear();

    // Bluetooth Devices update
    BluezConnector* bluezConnector = BluezConnector::getDefaultConnector();
    if (bluezConnector->countDevices() == 0)
    {
        localdevices->insertItem( tr( "No Bluetooth devices found !" ) );
        return;
    }

    for (int i=0;i<(bluezConnector->countDevices());i++)
    {
        QString str =
          QString::fromAscii(bluezConnector->getCurrentDevice()->getStrType());
        localdevices->insertItem( *(getPixmap(&str)),
                                  tr( bluezConnector->getCurrentDevice()->getDev() ) );
        bluezConnector->nextDevice();
    }
}

void DevicesWindow::cleanWindowContent() {
    combo_status->setCurrentItem(COMBO_UNKNOWN);
    combo_inquiry_scan_enabled->setCurrentItem(COMBO_UNKNOWN);
    combo_page_scan_enabled->setCurrentItem(COMBO_UNKNOWN);
    combo_encryption_enabled->setCurrentItem(COMBO_UNKNOWN);
    combo_authentication_enabled->setCurrentItem(COMBO_UNKNOWN);
    lineedit_name->clear();
    lineedit_bdaddress->clear();
    lineedit_name->clear();
    setEnabled(FALSE);
}

void DevicesWindow::setEnabled(bool enabled) {
    bool cenabled = enabled;
    enabled = enabled && getUserIsRoot();
    combo_status->setEnabled(enabled);
    combo_inquiry_scan_enabled->setEnabled(enabled);
    combo_page_scan_enabled->setEnabled(enabled);
    combo_encryption_enabled->setEnabled(enabled);
    combo_authentication_enabled->setEnabled(enabled);
    lineedit_name->setReadOnly(!enabled);

    pushbutton_reset->setEnabled(cenabled);
    pushbutton_show_details->setEnabled(cenabled);
    pushbutton_device_class->setEnabled(cenabled);
}

void DevicesWindow::setFormValues(BluezConnector::KBTDevice* dev)
{
    //  cout << "status: " << dev->getStatus() << endl;
    combo_status->setCurrentItem(flagsToCombo(dev->getStatus()));
    combo_status_old_value = combo_status->currentItem();

    if (dev->getStatus())
        lineedit_name->setText(dev->getName());
    else
        lineedit_name->clear();

    cout << "set bdaddr: " << dev->getBDAddr() << endl;
    lineedit_bdaddress->setText(dev->getBDAddr());

    combo_inquiry_scan_enabled->setCurrentItem(flagsToCombo(dev->getIScan()));
    combo_page_scan_enabled->setCurrentItem(flagsToCombo(dev->getPScan()));
    combo_encryption_enabled->setCurrentItem(flagsToCombo(dev->getEncrypt()));
    combo_authentication_enabled->setCurrentItem(flagsToCombo(dev->getAuth()));
    setEnabled(TRUE);
}

int DevicesWindow::flagsToCombo(int _flag) {
cout << "flagsToCombo: " << _flag << endl;
    if (_flag == BT_ENABLED)
        return COMBO_ENABLED;
    if (_flag == BT_DISABLED)
        return COMBO_DISABLED;
    if (_flag == BT_UNKNOWN)
        return COMBO_UNKNOWN;
    return -1;
}

int DevicesWindow::comboToFlags(int _combo) {
cout << "comboToFlags: " << _combo << endl;
    if (_combo == COMBO_ENABLED);
        return BT_ENABLED;
    if (_combo == COMBO_DISABLED);
        return BT_DISABLED;
    if (_combo == BT_UNKNOWN);
        return COMBO_UNKNOWN;
    return -1;
}

QPixmap* DevicesWindow::getPixmap(QString* _label) {
  cout << "returning pixmap for " << _label->ascii() << endl;
  if (*_label == "USB") return &QPixmap_USB;
  if (*_label == "USB ") return &QPixmap_USB; // a small bug in BlueZ libs :)
  if (*_label == "PCCARD") return &QPixmap_PCCARD;
  if (*_label == "PCI") return &QPixmap_PCI;
  if (*_label == "VHCI") return &QPixmap_VHCI;
  return &QPixmap_UNKNOWN;
}

void DevicesWindow::closeEvent(QCloseEvent*) {
    kapp->quit();
    delete this;
}

/*
 *  Destroys the object and frees any allocated resources
 */
DevicesWindow::~DevicesWindow()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DevicesWindow::languageChange()
{
    setCaption( tr( "KDE Bluetooth Utility - View local devices" ) );
    //    label_local_installed_devices->setText( tr( "<font size=\"+1\">Local installed devices</font>" ) );
    buttongroup_devices->setTitle("Devices");
    buttongroup_details->setTitle("Device details");
    label_authentication_2->setText( tr( "Encryption:" ) );
    label_inquiry_scan->setText( tr( "Inquiry Scan:" ) );
    label_page_scan->setText( tr( "Page Scan:" ) );
    label_authentication->setText( tr( "Authentication:" ) );
    combo_status->clear();
    combo_status->insertItem( QString::null );
    combo_status->insertItem( tr( "UP" ) );
    combo_status->insertItem( tr( "DOWN" ) );
    label_status->setText( tr( "Status:" ) );
    combo_inquiry_scan_enabled->clear();
    combo_inquiry_scan_enabled->insertItem( QString::null );
    combo_inquiry_scan_enabled->insertItem( tr( "ENABLED" ) );
    combo_inquiry_scan_enabled->insertItem( tr( "DISABLED" ) );
    combo_page_scan_enabled->clear();
    combo_page_scan_enabled->insertItem( QString::null );
    combo_page_scan_enabled->insertItem( tr( "ENABLED" ) );
    combo_page_scan_enabled->insertItem( tr( "DISABLED" ) );
    combo_encryption_enabled->clear();
    combo_encryption_enabled->insertItem( QString::null );
    combo_encryption_enabled->insertItem( tr( "ENABLED" ) );
    combo_encryption_enabled->insertItem( tr( "DISABLED" ) );
    combo_authentication_enabled->clear();
    combo_authentication_enabled->insertItem( QString::null );
    combo_authentication_enabled->insertItem( tr( "ENABLED" ) );
    combo_authentication_enabled->insertItem( tr( "DISABLED" ) );
    label_name->setText( tr( "Device Name:" ) );
    label_bdaddress->setText( tr( "BD Address:" ) );
    pushbutton_update->setText( tr( "Update !" ) );
    pushbutton_reset->setText( tr( "Reset Device" ) );
    pushbutton_show_details->setText( tr( "Show details" ) );
    pushbutton_device_class->setText( tr( "Change Class" ) );
}

