//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef DCOPCALL_H
#define DCOPCALL_H

#include <dcopclient.h>
#include <qcstring.h>
#include <qdatastream.h>
#include <qstring.h>

/**
@author Fred Schaettgen
*/
class DCOPCall {
public:
    DCOPCall(DCOPClient* client, QString app, QString obj);
    ~DCOPCall();
    QString call(QString func);
    QDataStream& args();
    QDataStream& ret();

private:
    DCOPClient* client;
    QString app;
    QString obj;
    QDataStream *argStream;
    QDataStream *retStream;
    QByteArray argArray;
    QByteArray retArray;
};


#endif
