//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <iostream>
#include <libkbluetooth/configinfo.h>

#include "application.h"
static const char *description =
    I18N_NOOP("KBluetoothD - Bluetooth Meta Server");

static KCmdLineOptions options[] =
{
    { "dontforceshow", I18N_NOOP("Show the tray icon if it was disabled before." ), 0},
    { 0, 0, 0 }
};

int main(int argc, char *argv[])
{
    KAboutData aboutData("kbluetoothd",
                         I18N_NOOP("KBluetoothD"),
                         KDEBluetoothConfig::version, 
			 description, KAboutData::License_GPL,
                         "(c) 2003-2004, Fred Schaettgen", 0, "http://bluetooth.kmobiletools.org");
    aboutData.addAuthor("Fred Schaettgen", I18N_NOOP("Author"), "kbluetoothd@schaettgen.de");
    aboutData.addAuthor("Marco Gulino", I18N_NOOP("Current Maintainer"), "marco@kmobiletools.org");
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );
    KUniqueApplication::addCmdLineOptions();

    if (!KUniqueApplication::start()) {
        // fprintf(stderr, i18n("KBluetoothD was already running.\n").local8Bit());
        std::cerr << i18n("KBluetoothD was already running.\n").local8Bit();
        return 0;
    }
    KBluetoothdApp a;
    return a.exec();
}

