//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef MONITORAPPLICATION_H
#define MONITORAPPLICATION_H

#include <kuniqueapplication.h>
#include <qptrlist.h>
#include <qcstring.h>
#include <qguardedptr.h>

class KConfig;
namespace KBluetooth {
    class HciSocket;
}
class TrayIcon;
class MetaServer;
class DeviceNameCache;
class DeviceScanner;
class PinServer;
class MostRecentlyUsed;
class HciListener;
class HciDevMonitor;

class KBluetoothdApp: public KUniqueApplication
{
Q_OBJECT
public:
    KBluetoothdApp();
    ~KBluetoothdApp();
    virtual int newInstance();

    QGuardedPtr<HciDevMonitor> hciDevMonitor;
    QGuardedPtr<HciListener> hciListener;
    QGuardedPtr<KBluetooth::HciSocket> hciSocket;
    QGuardedPtr<TrayIcon> trayIcon;
    QGuardedPtr<MetaServer> metaServer;
    QGuardedPtr<DeviceNameCache> deviceNameCache;
    QGuardedPtr<DeviceScanner> deviceScanner;
    QGuardedPtr<PinServer> pinServer;
    QGuardedPtr<MostRecentlyUsed> mru;
private slots:
    void slotHciDeviceFound();
    void slotHciDeviceLost();
    void configUpdate();
private:
    void startServices();
    void endServices();
    KConfig* m_config;
    bool bFirstNewInstance;
};


#endif
