/***************************************************************************
                          irmcsyncconfig.h  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef IRMCSYNCCONFIG_H
#define IRMCSYNCCONFIG_H

#include <qlayout.h>
#include <qlineedit.h>

#include <kresources/configwidget.h>

#include <libkbluetooth/serviceselectionwidget.h>

class QComboBox;
class QRadioButton;

class IrMCSyncConfig : public KRES::ConfigWidget
{
	Q_OBJECT
public:
	IrMCSyncConfig( QWidget *parent, const char *name = 0 );
	~IrMCSyncConfig();

public slots:
	void loadSettings( KRES::Resource *resource );
	void saveSettings( KRES::Resource *resource );

private slots:
	void slotServiceChanged( KBluetooth::DeviceAddress, uint );
  void slotTypeChanged( int );

private:
	void initUI();
  QWidget *createBluetoothPage();
  QWidget *createSerialPage();

  QComboBox *m_cmbPhoneModel;
  QComboBox *m_cmbType;
	QRadioButton *m_chkSyncCalendar;
  QRadioButton *m_chkSyncAddressBook;
	
	QComboBox *m_cmbDeviceBtAddress;
	
  QComboBox *m_cmbDevice;
  QComboBox *m_cmbDeviceSpeed;
	
  QWidget *m_wdgBluetoothPage;
  QWidget *m_wdgSerialPage;

	KBluetooth::ServiceSelectionWidget *m_serviceSelector;
};

#endif
