/*****************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen <kdebluetooth@schaettgen.de>
 *   Copyright (C) 2004 by Alex Ibrado <alex@kdex.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *****************************************************************************/

#ifndef XMMSCONTROLLER_H
#define XMMSCONTROLLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_XMMS

#define STEN_POLL_TIME 500

#include <controller.h>
#include <qstringlist.h>
#include <qtimer.h>

/**
@author Fred Schaettgen
*/
class XmmsController : public Controller
{
Q_OBJECT
public:
    XmmsController(QObject* parent);
    ~XmmsController();
    void commandDINF(unsigned int &bitrate,
        unsigned int &sampleRate, unsigned int &channels);
    QByteArray commandDOWN(QString filename);
    void commandFADE();
    void commandFFWD();
    SongInfo commandINFO();
    SongInfo commandINF2();
    void commandLADD(QString filename);
    QStringList commandLIST();
    void commandNEXT();
    void commandPAUS();
    void commandPLAY(QString filename, bool clear = false);
    QStringList commandPLST(int &curPos, bool useFilenames = false);
    void commandPREV();
    void commandREPT(bool repeat);
    void commandRMAL();
    void commandRWND();
    void commandSHFL(bool shuffle);
    void commandSLCT(Q_UINT16 index);
    void commandSTEN();
    void commandSTOP();
    void commandSTRT();
    void commandVOLM(Q_UINT8 volume);
    bool commandFULL();
    void commandSEEK(Q_UINT32 seconds);
    Q_UINT32 commandPLEN();
    bool commandGVOL(Q_UINT8 &volume);
    int currentIndex();

private slots:
    void stenCheck();

private:
    void waitForTrackChange(int oldPos);
    void waitForStart();
    void waitForPause();
    void waitForStop();

    // STEN support
    QTimer stenTimer;
    int stenLength;
    bool stenActive;

    // Hidden command
    int stopHits;
};

#endif // HAVE_XMMS
#endif
