/*****************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen <kdebluetooth@schaettgen.de>
 *   Copyright (C) 2003-2005 by Alex Ibrado <alex@kdex.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *****************************************************************************/

#ifndef SCRIPTSCONTROLLER_H
#define SCRIPTSCONTROLLER_H

#include "controller.h"
#include <qstringlist.h>

class DCOPClient;

/**
@author Alex Ibrado
*/
class ScriptsController : public Controller
{
Q_OBJECT
public:
    ScriptsController(QObject* parent);
    ~ScriptsController();
    void commandCHCK();
    void commandDINF(unsigned int &bitrate,
        unsigned int &sampleRate, unsigned int &channels);
    void commandFADE();
    void commandFFWD();
    int commandFINF(QString filename);
    SongInfo commandINFO();
    SongInfo commandINF2();
    void commandLADD(QString filename);
    QStringList commandLIST();
    void commandNEXT();
    void commandPAUS();
    void commandPLAY(QString filename, bool clear = false);
    QStringList commandPLST(int &curPos, bool useFilenames = false);
    void commandPREV();
    void commandREPT(bool repeat);
    void commandRMAL();
    void commandRWND();
    void commandSHFL(bool shuffle);
    void commandSHUT();
    void commandSLCT(Q_UINT16 index);
    void commandSTEN();
    void commandSTOP();
    void commandSTRT();
    void commandVOLM(Q_UINT8 volume);
    bool commandFULL();
    void commandSEEK(Q_UINT32 seconds);
    Q_UINT32 commandPLEN();
    bool commandGVOL(Q_UINT8 &volume);
    int currentIndex();

private:
    int selectedScript;
    KConfig* scriptsCfg;
    QStringList scriptsList;
    bool lastRepeat;
    bool lastShuffle;
    bool useCustomPlaylist;
    bool showingCustomPlaylist;
    bool mustListScripts;
    Controller::SongInfo parseInfo(QStringList output);
    bool call(QString exe, QStringList param, QStringList *output = NULL);
};

#endif
