/***************************************************************************
 *   Copyright (C) 2004 by Alex Ibrado <alex@kdex.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kurltableitem.h"

#include <qtable.h>
#include <qobject.h>
#include <qwidget.h>
#include <kurlrequester.h>
#include <kurlcompletion.h>
#include <kfiledialog.h>
#include <qevent.h>

KURLTableItem::KURLTableItem(QTable* table, const QString &text, const KURLCompletion::Mode cmode, const KFile::Mode fmode)
    : QTableItem(table, QTableItem::WhenCurrent, text)
{
    init(cmode, fmode);
}

KURLTableItem::KURLTableItem(QTable* table, EditType et, const QString & text)
    : QTableItem(table, et, text)
{
    init(KURLCompletion::FileCompletion);
}

void KURLTableItem::init(KURLCompletion::Mode cmode, KFile::Mode fmode)
{
    completionmode = cmode;
    filemode = fmode | KFile::ExistingOnly | KFile::LocalOnly;
    setReplaceable(false);
}

void KURLTableItem::setCompletionMode(KURLCompletion::Mode cmode)
{
    completionmode = cmode;
}

QWidget *KURLTableItem::createEditor() const
{
    QTable *tbl = table();
    ((KURLTableItem *)this)->kti = new KURLRequester(tbl->viewport());
    kti->setURL(text());
    if(completionmode) 
        kti->completionObject()->setMode(completionmode);

    if(filemode)
        kti->fileDialog()->setMode(filemode);
    
    tbl->setTabOrder(kti->button(), tbl);
    kti->button()->setAutoDefault(false);
    kti->button()->setFlat(true);
    // QObject::connect( kti, SIGNAL( returnPressed() ), tbl, tbl->activateNextCell() );
    //QObject::connect( kti, SIGNAL( activated( int ) ), table(), SLOT( doValueChanged() ) );
    return kti;
}

void KURLTableItem::setText(const QString &s)
{
    if(kti) 
        kti->setURL(s);
    
    QTableItem::setText(s);
}

void KURLTableItem::setContentFromEditor(QWidget *w)
{
    if(w->inherits("KURLRequester")) {
        QString currentText=((KURLRequester*)w)->url();
        setText(currentText);
    } else
        QTableItem::setContentFromEditor( w );
}

KURLRequester* KURLTableItem::urlRequester()
{
    // For the tab order
    return kti;
}

int KURLTableItem::rtti()
{
    return 1974013001;
}

KURLTableItem::~KURLTableItem()
{
}


