/***************************************************************************
                            KLed.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 
 Display a round  or rectangular light emitting diode.

 It is configurable to five colors, the two on/off states and three
 styles (or "looks");

 It may display itself in a performant flat view, a round view with
 light spot or a round view sunken in the screen.

 See {@link KLedSignals} for signals emitted by KLed.

 See {@link KLedEventHandling} for event handlers to override in subclasses of KLed.

 @author Joerg Habenicht, Richard J. Moore (rich@kde.org) 1998, 1999
 
 @short An LED widget.

*/
public class KLed extends QWidget  {
	protected KLed(Class dummy){super((Class) null);}


/** 
 Constructs a green, round LED widget which will initially
 be turned on.
   
*/
	private native void newKLed( QWidget parent, String name);
	public KLed( QWidget parent, String name) {
		super((Class) null);
		newKLed( parent, name);
	}
	private native void newKLed();
	public KLed() {
		super((Class) null);
		newKLed();
	}

/** 
 Constructor with the ledcolor, the parent widget, and the name.

 The State will be defaulted On and the Look round.

*/
	private native void newKLed( QColor col, QWidget parent, String name);
	public KLed( QColor col, QWidget parent, String name) {
		super((Class) null);
		newKLed( col, parent, name);
	}
//	private native void newKLed();
//	public KLed() {
//		super((Class) null);
//		newKLed();
//	}

/** 
 Constructor with the ledcolor, ledstate, ledlook,
 the parent widget, and the name.

 Differs from above only in the parameters, which configure all settings.

*/
	private native void newKLed( QColor col, int st, int look, int shape, QWidget parent, String name);
	public KLed( QColor col, int st, int look, int shape, QWidget parent, String name) {
		super((Class) null);
		newKLed( col, st, look, shape, parent, name);
	}
	private native void newKLed( QColor col, int st, int look, int shape);
	public KLed( QColor col, int st, int look, int shape) {
		super((Class) null);
		newKLed( col, st, look, shape);
	}

/** 
 Destructor

*/
	protected native void finalize() throws InternalError;

/** 
 Hand back the current state of the widget (on/off).

*/
	public native int state();
	public native int shape();

/** 
 Hand back the color of the widget

*/
	public native QColor color();

/** 
 Hand back the look of the widget.

*/
	public native int look();

/** 
 hands back the factor to darken the LED.

*/
	public native int darkFactor();

/** 
 Sets the state of the widget to On or Off.

 The widget will be painted immediately.

*/
	public native void setState( int state);

/**  Set the shape. 
*/
	public native void setShape( int s);

/** 
 Toggle the state of the LED from Off to On and vice versa.

 The widget will be repainted when returning to the main
 event loop.

*/
	public native void toggleState();

/** 
 Set the color of the widget.
 The Color is shown with the KLed.On state.
 The KLed.Off state is shown with QColor.dark() method

 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
	public native void setColor( QColor color);

/** 
 Set the factor to darken the LED in OFF state.
 Same as {@link QColor#dark}.
 "darkfactor should be greater than 100, else the LED gets lighter
 in OFF state.
 Defaults to 300.

*/
	public native void setDarkFactor( int darkfactor);

/** 
 Set the look of the widget.

 The look may be flat, round or sunken.
 The widget calls the update() method, so it will
 be updated when entering the main event loop.

*/
	public native void setLook( int look);

/** 
 Toggle the state of the led from Off to On or vice versa.

 The widget repaints itself immediately.
   
*/
	public native void toggle();

/** 
 Sets the state of the widget to On.

 The widget will be painted immediately.

*/
	public native void on();

/** 
 Sets the state of the widget to Off.

 The widget will be painted immediately.

*/
	public native void off();

/** 
 Paints a circular, flat LED.
   
*/
	protected native void paintFlat();

/** 
 Paints a circular, raised LED.
   
*/
	protected native void paintRound();

/** 
 Paints a circular, sunken LED.
   
*/
	protected native void paintSunken();

/** 
 Paints a rectangular, flat LED.
   
*/
	protected native void paintRect();

/** 
 Paints a rectangular LED, either raised or 
 sunken, depending on its argument.
   
*/
	protected native void paintRectFrame( boolean raised);
	public static final int Off = 0;
	public static final int On = 1;
	public static final int Rectangular = 0;
	public static final int Circular = 1;
	public static final int Flat = 0;
	public static final int Raised = 1;
	public static final int Sunken = 2;
}
