//////////////////////////////////////////////////////////////
// 	$Id: rpmInterface.h,v 1.17 2001/04/02 16:27:50 toivo Exp $	
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef RPM_IFACE_H
#define RPM_IFACE_H

#include "../config.h"

#ifdef HAVE_RPM
#include <sys/types.h>
/* stupid RPM headers! */
typedef __off64_t off64_t;
#include <rpm/rpmlib.h>
#else
  typedef struct  Header{
};
#endif

#include <qlist.h>

#include "packageInfo.h"
#include "pkgInterface.h"

class KDir;
class cacheObj;

class RPM : public pkgInterface
{
 Q_OBJECT

public:
  RPM(QString remote);
  ~RPM();
  
  bool isType(char *buf, const QString &fname);

  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList getFileList(packageInfo *p);
  QStringList depends(const QString &name, int src);
  QStringList verify(packageInfo *p, const QStringList &files);

  QString uninstall(int uninstallFlags, QList<packageInfo> *p, bool &test);
  QString uninstall(int uninstallFlags, packageInfo *p, bool &test);
  QString doUninst(int uninstallFlags, const QStringList &files, bool &test);
  QString doUninstP(int uninstallFlags, const QStringList &files, bool &test);

  QString install(int installFlags, QList<packageInfo> *p, bool &test);
  QString install(int installFlags, packageInfo *p, bool &test);
  QString doinst(int installFlags, const QStringList &files, bool &test);
  QString doinstP(int installFlags, const QStringList &files, bool &test);

  QStringList FindFile(const QString &name);
  void collectDepends(packageInfo *p, const QString &name, int src);
  bool parseName(QString name, QString *n, QString *v);

  QString provMap(QString p);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(Header h);
  QStringList collectFileList(Header h);
  void listInstalledPackages(QList<packageInfo> *pki);

  QDict<QString> provides;
  bool rpmSetup;
 };

#endif



