/***************************************************************************
                             domlistviewitem.cpp
                             -------------------

    author               : Andreas Schlapbach
    email                : schlpbch@iam.unibe.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* $Id: domlistviewitem.cpp,v 1.3 2001/05/21 19:03:16 schlpbch Exp $ */
 
#include <qpainter.h>

#include "domlistviewitem.h"
#include <qlistview.h>

DOMListViewItem::DOMListViewItem( QListView *parent )
  : QListViewItem( parent )
{
  init();
}

DOMListViewItem::DOMListViewItem( QListView *parent, QListViewItem *after)
  : QListViewItem( parent, after )
{
  init();
}

DOMListViewItem::DOMListViewItem( QListViewItem *parent )
  : QListViewItem( parent )
{
  init();
}

DOMListViewItem::DOMListViewItem( QListViewItem *parent, QListViewItem *after)
  : QListViewItem( parent, after )
{
  init();
}

DOMListViewItem::~DOMListViewItem()
{
  //NOP
}

void DOMListViewItem::init()
{
  m_color = QColor(Qt::black);
  m_font = QFont("Helvetica", 8);
}

void DOMListViewItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment )
{
  QColorGroup _cg( cg );
  QColor c = _cg.text();

  p->setFont(m_font);
  _cg.setColor( QColorGroup::Text, m_color );
  QListViewItem::paintCell( p, _cg, column, width, alignment );
  _cg.setColor( QColorGroup::Text, c );
}


