/***************************************************************************
 *   Copyright (C) 2005 by Siraj Razick                                    *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef KBFX_SPINX_TOP_H
#define KBFX_SPINX_TOP_H
#include <qwidget.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qimage.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qimage.h>
#include <kuser.h>		//drop suppor for kde 3.2 , sorry
#include <dcopref.h>
#include <qvariant.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qiconview.h>
#include <qframe.h>
#include <qlayout.h>
#include <krun.h>
//#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qdir.h>
#include <kdesktopfile.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kicontheme.h>
#include <kprocess.h>
#include <qheader.h>
#include <qfileinfo.h>
#include <kmessagebox.h>
#include <krun.h>
#include <kurl.h>
#include <kservice.h>
#include <kservicegroup.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kservicetype.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kimageeffect.h>
#include <kcombobox.h>
#include <ktabwidget.h>
#include <kuser.h>

/**
@author Siraj Razick
*/
class KbfxSpixTop:public QLabel
{
Q_OBJECT public:
  KbfxSpixTop (QWidget * parent = 0, const char *name = 0);

   ~KbfxSpixTop ();
  virtual void mouseMoveEvent ( QMouseEvent * e );
  virtual void paintEvent (QPaintEvent *);
  virtual void timerEvent (QTimerEvent * e);
  QPixmap compositePixmap (QPixmap src, QPixmap dest);
  void setBgPixmap(QPixmap);
  void setUserImage (QPixmap pixmap)
  {
    userImage = pixmap;
  }
  void setBoundBox (QPixmap box)
  {
    boundBox = box;
  }
  QPixmap getKDEIcon (QString name);
  QString getUserName ();

  virtual void mousePressEvent (QMouseEvent * e);

  virtual void mouseReleaseEvent (QMouseEvent * e);  
  virtual void enterEvent (QEvent * e)
  {
	e = e;
     _timer->stop();
   // _timer->start ( _timeout , FALSE);
   _downOffSet = this->height () - (down.height () + 5);
   _upOffSet = 4;
    this->update ();
if(_itemCount > 6)
    moseEnter = 1;
  }
  virtual void leaveEvent (QEvent *)
  {
// moseEnter = 0;
   _timer->stop();
    this->update ();

  }

  public slots:

void scrollArrowsOn()
{
	_timer->stop();
	_downOffSet = this->height()/2;;
  	_upOffSet = this->height()/2;

        _timer->start ( _timeout, FALSE);
//	_scrollTimer->start(_timeout,FALSE);
	moseEnter = 1; //I know some swedesh..well only one word mose=mouse;
	this->update();
}

void scrollArrowsOff()
{
	_timer->stop();
	_downOffSet = this->height()/2;;
  	_upOffSet = this->height()/2;
	moseEnter = 0; //I know some swedesh..well only one word mose=mouse;
	this->update();
	_timer->stop();

}
void animate ();
void animateScrollBar();
void startScroll();
signals:
	void scroll(int);
	;
private:
  QPixmap userImage;
  QPixmap boundBox;
QPixmap *_m_bg ;
  QPixmap up;
  QPixmap down;
  int moseEnter;
  QPixmap scrollText_down;
  QPixmap scrollText_up;
  QPixmap scrollText_settings;
  int _frame;
  int _in;
  double _inte;
  QTimer * _timer;
 QTimer * _scrollTimer;
  int _upOffSet;
  int _downOffSet;
  double _opacity;
  int _timeout;
 int _itemCount;
 int _delta;
 QPixmap  * pixmapbuff;
	 QColor m_userNameColor;
};

#endif
