/***************************************************************************
                          dirsynchtreeview.cpp  -  description
                             -------------------
    begin                : lr okt 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qsizepolicy.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfiletreebranch.h>
#include <kfiletreeviewitem.h>
#include <kfileitem.h>
#include <klocale.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "dirsynchtreeview.h"
#include "dirsynchtreeviewitem.h"

//-----------------------------------------------
DirSynchTreeView::DirSynchTreeView(QWidget *parent, const char *name )
	:	KFileTreeView(parent,name)
{
	setSizePolicy( QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding, 0, 0, sizePolicy().hasHeightForWidth() ) );
	addColumn( i18n( "Name" ) );
	addColumn( i18n( "Size" ) );
	addColumn( i18n( "Modified" ) );
	addColumn( i18n( "Permissions" ) );
	setSelectionModeExt( KListView::Single );
	setAllColumnsShowFocus( true );
	setShowSortIndicator( false );
	setFullWidth( false );
	setRootIsDecorated( false );
	setAcceptDrops( false );
	setDragEnabled( true );
	setItemsMovable( false );
}
//-----------------------------------------------
DirSynchTreeView::~DirSynchTreeView(){
}
//-----------------------------------------------
KFileTreeBranch* DirSynchTreeView::addBranch( const KURL& path, const QString& name,
									const QPixmap& pix, bool showHidden )
{
	/* Open a new branch */
	KFileTreeBranch* newBranch = new DirSynchTreeBranch( this, path, name, pix, showHidden );
	// we need to create a new root item
/*
	delete newBranch->root();
	KFileTreeViewItem* root =  new DirSynchTreeViewItem( this, new KFileItem( path, "inode/directory", S_IFDIR  ), newBranch );
	root->setPixmap( 0, pix );
	root->setText( 0, name );
	newBranch->setRoot( root );
*/
	return KFileTreeView::addBranch( newBranch );
}
//-----------------------------------------------
void DirSynchTreeView::setSorting( int col, bool asc ) {
	if( columnSorted() == col && ascendingSort() == asc )
		return;
	KListView::setSorting( col, asc );
	emit sortingChanged( col, asc );
}
//-----------------------------------------------
void DirSynchTreeView::slotHeaderSizeChange( int col, int , int n ) {
	if( columnWidth( col ) != n )
		setColumnWidth( col, n );
	
}
//-----------------------------------------------
