#include <gcutter.h>

#include "kz-bookmark.h"
#include "kz-test-utils.h"

void kz_test_warmup (void);

static gboolean
kz_bookmark_type_equal_func (gconstpointer v1, gconstpointer v2)
{
    const GValue *value1 = v1;
    const GValue *value2 = v2;
    KzBookmark *bookmark1, *bookmark2;

    bookmark1 = g_value_get_object(value1);
    bookmark2 = g_value_get_object(value2);

    return kz_test_equal_bookmark(bookmark1, bookmark2);
}

void
kz_test_warmup (void)
{
    gcut_value_register_equal_func(KZ_TYPE_BOOKMARK, KZ_TYPE_BOOKMARK,
                                   kz_bookmark_type_equal_func);
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
