/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_EMBED_H__
#define __KZ_MOZ_EMBED_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>
#include "kazehakase.h"
#include "kz-embed-event.h"
#include "kz-embed.h"

G_BEGIN_DECLS

#define KZ_TYPE_MOZ_EMBED		(kz_moz_embed_get_type ())
#define KZ_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbed))
#define KZ_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))
#define KZ_IS_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_MOZ_EMBED))
#define KZ_IS_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_MOZ_EMBED))
#define KZ_MOZ_EMBED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))

typedef struct _KzMozEmbed	KzMozEmbed;
typedef struct _KzMozEmbedClass	KzMozEmbedClass;
typedef struct _KzMozEmbedPriv	KzMozEmbedPriv;

struct _KzMozEmbed
{
	/* embedding widget */
	GtkMozEmbed parent;

	/* image popup window */
	GtkWidget *popup_window;
	
	/* location and title */
	gchar *location;
	gchar *title;

	gint load_started; /* count of currently active connections */
	gint load_percent;
	gint bytes_loaded;
	gint max_bytes_loaded;
	gboolean  is_loading;
	const gchar *load_status_message;
	
	KzMozEmbedPriv *priv;
};

struct _KzMozEmbedClass
{
	GtkMozEmbedClass parent_class;
};


GtkType      kz_moz_embed_get_type              (void);
GtkWidget   *kz_moz_embed_new                   (const gchar *url);

#if 1
glong        kz_moz_embed_get_key_event_info    (KzMozEmbed  *kzembed,
						 gpointer     event,
						 KzEmbedEventKey **info);
glong        kz_moz_embed_get_mouse_event_info  (KzMozEmbed  *kzembed,
						 gpointer     event,
						 KzEmbedEventMouse **info);
#endif

G_END_DECLS

#endif /* __KZ_MOZ_EMBED_H__ */
