#ifndef _VALUEFUNS_H
#define _VALUEFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

#include <vector>
#include <map>
#include "sizes.h"

class Value;
class VMState;
class String;

typedef kint valtype;
// doesn't really matter what order these go in, as long as KVT_UNION is zero,
// and all the others are negative. Any positive is then the U_TAG.
// valtype being signed
#define KVT_INT -8
#define KVT_CUNION -7
#define KVT_STRING -6
#define KVT_FUNC -5
#define KVT_ARRAY -4
#define KVT_EXCEPTION -3
#define KVT_REAL -2
#define KVT_NULL -1
#define KVT_UNION 0

//typedef enum { KVT_NULL, KVT_INT, KVT_STRING, KVT_FUNC, KVT_ARRAY, KVT_UNION, KVT_EXCEPTION, KVT_REAL } valtype;

extern "C" {
    kint inttable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint inttable_fasteq(Value*, Value*);
    kint inttable_cmp(Value*, Value*);
    Value* inttable_fastcopy(VMState*,Value*);
    void inttable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* inttable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int inttable_memusage(Value*);
    kint inttable_hash(Value*);

    kint fntable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint fntable_cmp(Value*, Value*);
    Value* fntable_copy(VMState*, Value*, map<Value*,Value*>& done);
    void fntable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* fntable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int fntable_memusage(Value*);
    kint fntable_hash(Value*,vector<Value*>&);

    kint realtable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint realtable_fasteq(Value*, Value*);
    kint realtable_cmp(Value*, Value*);
    Value* realtable_fastcopy(VMState*,Value*);
    void realtable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* realtable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int realtable_memusage(Value*);
    kint realtable_hash(Value*);

    kint stringtable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint stringtable_fasteq(Value*, Value*);
    kint stringtable_cmp(Value*, Value*);
    Value* stringtable_fastcopy(VMState*,Value*);
    void stringtable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* stringtable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int stringtable_memusage(Value*);
    kint stringtable_hash(Value*);

    kint arraytable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint arraytable_cmp(Value*, Value*);
    Value* arraytable_copy(VMState*, Value*, map<Value*,Value*>& done);
    void arraytable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* arraytable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int arraytable_memusage(Value*);
    kint arraytable_hash(Value*,vector<Value*>&);

    kint uniontable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint uniontable_cmp(Value*, Value*);
    Value* uniontable_copy(VMState*, Value*, map<Value*,Value*>& done);
    void uniontable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* uniontable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int uniontable_memusage(Value*);
    kint uniontable_hash(Value*,vector<Value*>&);

    kint cuniontable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint cuniontable_cmp(Value*, Value*);
    Value* cuniontable_copy(VMState*, Value*, map<Value*,Value*>& done);
    void cuniontable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* cuniontable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int cuniontable_memusage(Value*);
    kint cuniontable_hash(Value*);

    kint exceptiontable_eq(Value*, Value*, map<Value*,Value*>& done);
    kint exceptiontable_fasteq(Value*, Value*);
    kint exceptiontable_cmp(Value*, Value*);
    Value* exceptiontable_fastcopy(Value*);
    void exceptiontable_marshal(VMState*, String*, vector<Value*>&, Value*, kint id);
    Value* exceptiontable_reflect(VMState*, map<Value*, Value*>&, Value*);
    int exceptiontable_memusage(Value*);
    kint exceptiontable_hash(Value*);
}

#endif
