#ifndef _PG_INTER_H // -*-C++-*-
#define _PG_INTER_H

// Glue functions for talking to libpq

#include <stdfuns.h>
#include <KayaAPI.h>
#include <libpq-fe.h>
#include <map>

using namespace std;

typedef enum { DBTEXT, DBINT, DBFLOAT, DBBOOL, DBTIME } DBtype;

/// These class names are rubbish and confusing!!!!1!!!
class PGCon : public gc
{
public:
    PGconn* con;
    int ok;
    map<int, DBtype> typids;
};

class PGRes : public gc
{
public:
    KayaArray res_table;
    KayaArray col_names;
    int rows;
    int cols;
};

extern "C" {
/// Returns a PGCon
    void* pg_connect(wchar_t* conninfo);
/// Tests if a connection is ok
    bool pg_ok(void* conn);
/// Returns an error message
    wchar_t* pg_getError(void* conn);
/// Returns a PGRes
    void* pg_exec(void* vmptr,void* conn,wchar_t* query, KayaValue err);
/// Gets the strings from a PGRes
    KayaArray pg_getstrs(void* res);
/// Return the number of rows in a result
    int pg_numrows(void* res);
/// Return the number of columns in a result
    int pg_numcols(void* res);
/// Returns the field names in a result
    Array* pg_colnames(void* res);
/// Close the connection
    void pg_close(void* conn);
    void* do_pg_prepare(wchar_t* query);
    void* pg_execp(void* vmptr,void* conn,void* queryptr, KayaValue err, KArray params);
}

#endif
