#include <stdio.h>
#include <string.h>

//#include <openssl/evp.h>
#include <stdfuns.h>
#include <VMState.h>
#include <unistd.h>
#include <KayaAPI.h>

#include "crypto_glue.h"

extern char* kaya_secret;
extern char* kaya_ivec;

KayaArray getKey()
{
    KayaArray a = newKayaArray(32);
    // has a 3-char padding on each end for easy binary rekeying
    int x = 3;
    for(;x<35;++x) {
	KayaArrayPush(a,KayaInt((int)(kaya_secret[x])));
    }
    return a;
}

KayaArray getIVec()
{
    KayaArray a = newKayaArray(16);
    int x = 3;
    for(;x<19;++x) {
	KayaArrayPush(a,KayaInt((int)(kaya_ivec[x])));
    }
    return a;
}

/* // now moved to posix/LocalSystem - CIM
char* do_crypt (const char *key, const char *salt) {
#ifdef WIN32
  return "";
#else
  return crypt(key,salt);
#endif
} */

/*
char* encode(void* vmptr,char* str)
{
    VMState* vm = (VMState*)vmptr;
//    return b64enc(str,strlen(str));

    char* iniv = (char*)(GC_MALLOC(9));
    memcpy(iniv,kaya_ivec,9);
//    strcpy(iniv,kaya_ivec);
//    cout << "IVEC is " << b64enc(kaya_ivec,8) << endl;
//    cout << "<br>new IVEC is " << b64enc(iniv,8) << endl;

// FIXME! We should be testing return values and throwing an exception on 
// failure.
    EVP_CIPHER_CTX x;
    EVP_CIPHER_CTX_init(&x);
    EVP_EncryptInit(&x, EVP_des_ede3_cbc(), (unsigned char*)kaya_secret, (unsigned char*)iniv);

    unsigned char *enc, *msghash, *junk;
    msghash = (unsigned char*)GC_MALLOC(sizeof(char)*strlen(str)+32);
    enc = (unsigned char*)GC_MALLOC(sizeof(char)*strlen(str)+32);
    junk = (unsigned char*)GC_MALLOC(sizeof(char)*24);

    memset(msghash,0,strlen(str)+21);
    memset(enc,0,strlen(str)+32);
    memset(junk,0,24);

//    SHA1((unsigned char*)str,strlen(str),msghash);
    EVP_MD_CTX hx;
    EVP_DigestInit(&hx, EVP_sha1());
    EVP_DigestUpdate(&hx ,str, strlen(str));
    EVP_DigestFinal(&hx,msghash,NULL);

//    cout << "Making hash from " << (str) << endl;
//    cout << "<br>Get " << b64enc((char*)msghash,20) << "<br>" << endl;

    memcpy(msghash+20,str,strlen(str)+1);

    int num, foo, total;
    EVP_EncryptUpdate(&x, enc+4, &num, msghash, strlen(str)+28);
    EVP_EncryptFinal(&x, junk, &foo);
    EVP_CIPHER_CTX_cleanup(&x);
    memcpy(enc+4+num,junk,foo);
    total = num + foo;
    // Prepend total
    *enc = (char)((total >> 24) & 255);
    *(enc+1) = (char)((total >> 16) & 255);
    *(enc+2) = (char)((total >> 8) & 255);
    *(enc+3) = (char)(total & 255);

//    cout << str << "," << b64enc((char*)msghash,20);
//    cout << " : " << b64enc((char*)enc,total);
//    cout << "<br>Encoded as " << b64enc((char*)enc,total) << "<br>" << endl;

    return b64enc((char*)enc,total);
}

char* decode(void* vmptr,char* str)
{
    VMState* vm = (VMState*)vmptr;
    char* iniv = (char*)(GC_MALLOC(9));
    memcpy(iniv,kaya_ivec+3,9);
//    strcpy(iniv,kaya_ivec);

//    cout << "Decoding " << str << endl;
//    cout << "Get " << b64dec(str) << endl;

    KayaValue len = KayaInt(0);
    unsigned char* dstr = (unsigned char*)b64dec(str, len);

//    return (char*)dstr;

// Pull the length out
    int total = (int)((*dstr)<<24) +
	(int)((*(dstr+1))<<16) +
	(int)((*(dstr+2))<<8) +
	(int)((*(dstr+3)));

//    cout << "bit 2: " << (int)((*(dstr+2)) << 8) << endl;
//    cout << "bit 1: " << (int)(*(dstr+3)) << endl;
//    cout << "Length " << total << endl;

    EVP_CIPHER_CTX x;
    EVP_CIPHER_CTX_init(&x);

    // If the length is much longer than the original string we're decoding,
    // this is clearly nonsense, so return an error.
    if (total>strlen(str)) {
	vm->kaya_throw("Invalid string to decode",255);
    }

    unsigned char *dec, *junk, *msghash;
    dec = (unsigned char*)GC_MALLOC(sizeof(char)*total*2);
    junk = (unsigned char*)GC_MALLOC(sizeof(char)*48);
    msghash = (unsigned char*)GC_MALLOC(sizeof(char)*20);

    memset(msghash,0,20);
    memset(dec,0,total*2);
    memset(junk,0,48);

    int num,foo;

    char* ksecret = (char*)(GC_MALLOC(25));
    memcpy(ksecret,kaya_secret+3,24);
    ksecret[24] = '\0';

    EVP_DecryptInit(&x, EVP_des_ede3_cbc(), (unsigned char*)ksecret, (unsigned char*)iniv);
    EVP_DecryptUpdate(&x, dec, &num, (dstr+4), total);
    EVP_DecryptFinal(&x, junk, &foo);
    EVP_CIPHER_CTX_cleanup(&x);

    memcpy(dec+num,junk,foo);

    unsigned bar;
    EVP_MD_CTX hx;
    EVP_DigestInit(&hx, EVP_sha1());
    EVP_DigestUpdate(&hx, (dec+20), strlen((char*)dec+20));
    EVP_DigestFinal(&hx,msghash,&bar);

//    cout << "Making hash from " << (dec+20) << endl;

    if (memcmp(dec,msghash,20)!=0) {
//	cout << "Stored hash: " << b64enc((char*)dec,20) << endl;
//	cout << "New    hash: " << b64enc((char*)msghash,20) << endl;
//	cout << dec+20 << endl;
	String* val = new String("Bad hash for ");
	String* wrong = new String(str);
//	String* hash1 = new String((char*)(dec+20));
	String* hash1 = new String(b64enc((char*)dec,20));
	String* hash2 = new String(b64enc((char*)msghash,20));
	String* br = new String("<br>");

	char buf[20];
	sprintf(buf,"%d",bar);
	String* err = new String(buf);
	val->append(wrong);
	val->append(br);
	val->append(hash1);
	val->append(br);
	val->append(hash2);
	val->append(br);
	val->append(err);
	vm->kaya_throw(val->getVal(),255);
   }

    return (char*)(dec+20);
}
*/
