#include "infobox.h"

InfoBox::InfoBox( string caption, string text, QWidget *parent ) : QDialog( parent )
{
	resize( 410, 250 );
	setMinimumSize( 250, 100 );

	setCaption( caption.c_str() );

	Bclose = new QPushButton( this );
	Bclose->setText( "Close" );

	multiline = new QMultiLineEdit( this );
	multiline->setWordWrap( QMultiLineEdit::WidgetWidth );
	multiline->setText( ( this->text = text ).c_str() );

	QObject::connect( Bclose, SIGNAL( clicked() ), this, SLOT( close() ) ); 

	show();
}

void InfoBox::resizeEvent( QResizeEvent * )
{
	int w = this->width(), h = this->height();

	multiline->setGeometry( 10, 10, w-20, h-60 );
	Bclose->setGeometry( w/2-45, h-40, 90, 30 );
}
