#include <fstream>
using namespace std;

#include <qinputdialog.h>

#include "bookmarks.h"
#include "preferences.h"
#include "globals.h"
#include "browser.h"
#include "navigation.h"

Bookmarks::Bookmarks() : QDialog()
{
	setCaption( "Kascade Bookmarks" );
	resize( 410, 250 );
	setMinimumSize( 410, 250 );

	Bexit = new QPushButton( this );
	Bexit->setText( "Exit" );
	Bdelete = new QPushButton( this );
	Bdelete->setText( "Delete" );
	Bedit = new QPushButton( this );
	Bedit->setText( "Edit" );
	Bup = new QPushButton( this );
	Bup->setText( "Up" );
	Bdown = new QPushButton( this );
	Bdown->setText( "Down" );

	LBbookmarks = new QListBox( this ); 

	QObject::connect( Bexit, SIGNAL( clicked() ), this, SLOT( hide() ) );
	QObject::connect( Bedit, SIGNAL( clicked() ), this, SLOT( editBookmark() ) );
	QObject::connect( Bdelete, SIGNAL( clicked() ), this, SLOT( deleteBookmark() ) );
	QObject::connect( Bup, SIGNAL( clicked() ), this, SLOT( bookmarkUp() ) );
	QObject::connect( Bdown, SIGNAL( clicked() ), this, SLOT( bookmarkDown() ) );
	QObject::connect( LBbookmarks, SIGNAL( selected( int ) ), this, SLOT( bookmarkSelected( int ) ) ); 
}

void Bookmarks::deleteBookmark()
{
	int index = LBbookmarks->currentItem();
	if( index == -1 )
		return;

	LBbookmarks->removeItem( index );
	config->bookmarkv.erase( config->bookmarkv.begin()+2*index, config->bookmarkv.begin()+2*index+2 );

	browser->buildBookmarkMenu();
	save();
}

void Bookmarks::editBookmark()
{
	int index = LBbookmarks->currentItem();
	if( index == -1 )
		return;

	bool ok = FALSE;
	QString text = QInputDialog::getText( "Edit Bookmark", QString::null, \
											QLineEdit::Normal, config->bookmarkv[2*index].c_str(), \
											&ok, this, "Edit Bookmark" );

	if( ok )
	{
		config->bookmarkv[2*index] = (const char *)text;
		LBbookmarks->changeItem( text, index );

		browser->buildBookmarkMenu();
		save();
	}
}

void Bookmarks::bookmarkUp()
{
	int index = LBbookmarks->currentItem();
	if( index <= 0 )
		return;
	
	exchangeItems( index, index-1 );

	browser->buildBookmarkMenu();
	save();
}

void Bookmarks::bookmarkDown()
{
	int index = LBbookmarks->currentItem();
	if( ( index == -1 ) ||
	    ( index == LBbookmarks->count()-1 ) )
		return;

	exchangeItems( index, index+1 );

	browser->buildBookmarkMenu();
	save();
}

void Bookmarks::exchangeItems( int m, int n )
{
	string s1 = (const char *)(LBbookmarks->text( m ));
	string s2 = (const char *)(LBbookmarks->text( n ));
	LBbookmarks->changeItem( s1.c_str(), n );
	LBbookmarks->changeItem( s2.c_str(), m );

	string a1 = config->bookmarkv[2*m];
	string a2 = config->bookmarkv[2*m+1];
	string b1 = config->bookmarkv[2*n];
	string b2 = config->bookmarkv[2*n+1];
	config->bookmarkv[2*m] = b1;
	config->bookmarkv[2*m+1] = b2;
	config->bookmarkv[2*n] = a1;
	config->bookmarkv[2*n+1] = a2;

	LBbookmarks->setCurrentItem( n );
}	
	
void Bookmarks::resizeEvent( QResizeEvent * )
{
	int w = this->width(), h = this->height();
	
	Bdelete->setGeometry( w-110, 10, 100, 25 );
	Bedit->setGeometry( w-110, 40, 100, 25 );
	Bup->setGeometry( w-110, 80, 100, 25 );
	Bdown->setGeometry(w-110, 110, 100, 25 );
	Bexit->setGeometry( w-110, h-35, 100, 25 );  

	LBbookmarks->setGeometry( 10, 10, w-130, h-20 ); 
}

void Bookmarks::bookmarkSelected( int index )
{
	browser->update( action_jump( config->bookmarkv[2*index+1] ) );
}

void Bookmarks::update()
{
	LBbookmarks->clear();

	for( unsigned int n = 0; n < config->bookmarkv.size(); n += 2 )
		LBbookmarks->insertItem( config->bookmarkv[n].c_str() );

	show();
}

void Bookmarks::load()
{
	ifstream ifs;
	string file = getenv( "HOME" );
	file += "/.kascade/bookmarks";

	ifs.open( file.c_str() );

	if( !ifs.good() )
		return;

    	ifs.unsetf( ios::skipws );

	string name, address;

	while( !ifs.eof() )
	{
        	getline( ifs, name, '\n' );
        	getline( ifs, address, '\n' );

		if( name != "" )
		{
			config->bookmarkv.push_back( name );
			config->bookmarkv.push_back( address );
		}	
	}

	ifs.close();
}

void Bookmarks::save()
{
	ofstream ofs;
	string file = getenv( "HOME" );
	file += "/.kascade/bookmarks";
	ofs.open( file.c_str() );

	for( unsigned int n = 0; n < config->bookmarkv.size(); )
	{
		ofs << config->bookmarkv[n++] << endl;
		ofs << config->bookmarkv[n++] << endl;
	}

	ofs.close();
}
