/***************************************************************************
                          kgrammar.cpp  -  description
                             -------------------
    begin                : Tue Aug 1 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgrammar.h"
#include <qlist.h>
#include <iostream.h>
#include <stdio.h>

extern FILE * yyin;
int yyparse();
int yylex();

KGrammar::KGrammar()
{
  lastNonterminal=0;
  nextTerminal=0;
  nonterminals.setAutoDelete(true);
}

KGrammar::~KGrammar()
{
}

/* retrieves the rule which has r on the left side */
KRule * KGrammar::getRule(int r)
{
  QListIterator<KRule> it(rules);
  while (it.current())
  {
    if (it.current()->leftSide()==r) return it.current();
    ++it;
  }
  return it.current();
}

/* get the internal number for a non-terminal symbol */
bool KGrammar::isNonterminal(QString * s)
{
  int *i=nonterminals.find(*s);
  return i!=0;
}

	
/* get the internal number for a non-terminal symbol */
int KGrammar::storeNonterminal(QString * s)
{
  int *i=nonterminals.find(*s);
  if (!i)
  {
    lastNonterminal--;
    i=new int(lastNonterminal);
    nonterminals.insert(*s,i);
  }
  return *i;
}

/* get the internal number for a terminal symbol */
int KGrammar::storeTerminal(QString * s)
{
  terminals.append(s);
  return nextTerminal++;
}

/* get value for non-terminal */
QString KGrammar::getNonterminal(int i)
{
  QDictIterator<int> it(nonterminals);
  while (it.current())
  {
    if (*(it.current())==i) return it.currentKey();
    ++it;
  }
  QString s;
  s.setNum(i);
  return s;
}

/* get text for terminal */
QString KGrammar::getTerminal(int i)
{
  QListIterator<QString> it(terminals);
  int num=0;
  while (it.current())
  {
    if (num==i) return *it.current();
    ++num;
    ++it;
  }
  return QString();
}
	
/* get a number for a non-terminal which has no name */
int KGrammar::getNewNonterminal()
{
  return --lastNonterminal;
}

void KGrammar::addRule(KRule * rule)
{
  rules.append(rule);
  rule->print();
}


bool KGrammar::parse(const char * fname)
{
/*  yyin=fopen(fname,"rt");
  int i;
  while ((i=yylex())) if (i<256) printf("%c",i); else cout << i << '\t';
  fclose(yyin);       */

  bool res=false;
  /* standard input */
  if (!fname)
  {
    yyin=stdin;
    if (yyparse()==0) res=check();
  }
  else
  /* open a file */
  {
    if ( (yyin=fopen(fname,"rt")) && yyparse()==0 )
      res=check();
  }

  return res;

}

KRule * KGrammar::getTopLevelRule()
{
  return getRule(-1);
}

KRule * KGrammar::getStartRule()
{
  int *i=nonterminals.find("start");
  if (!i)
  {
    /* no start rule */
    return getRule(-1);
  }
  else
    return getRule(*i);
}

void printThis(int z, QList<int> l)
{
  cout <<z << " <- ";
  for (int *i=l.first(); i; i=l.next())
    cout << *i << ' ';
  cout << endl;
}

int QGList::compareItems(void * i1, void * i2)
{
  return *(int *)i1-*(int *)i2;
}

bool KGrammar::check()
{
  int * start=nonterminals.find("start");
  if (!start)
  {
    cerr << "No `start' rule." << endl;
    return false;
  }
  int i;
  for (i=0; i>lastNonterminal; i--)
  if (getRule(i-1)==0)
  {
    cerr << "Symbol `" << getNonterminal(i-1) << "' can not be termianted." << endl;
    return false;
  }
  int n=-lastNonterminal;
  QList<int> * isOnRight= new QList<int>[n]; /* inverse rules */
  bool * valid=new bool[n]; /* the validation of inverse rules */
  /* build structure: what right sides x nonterminal is part of */
  /* for every rule */
  for (i=0; i<n; i++)
  {
    valid[i]=true;
    isOnRight[i].setAutoDelete(true);
    KRule * rule=getRule(-i-1);
    QValueList<int> children=rule->children();
    QValueListIterator<int> it;
    /* and every nonterminal on the right side */
    for (it=children.begin(); it!=children.end(); ++it)
      isOnRight[-(*it)-1].append(new int(-rule->leftSide()-1));
  }

 loop:
  for (i=0; i<n; i++)
    if (valid[i] && isOnRight[i].isEmpty()) break;
  /* no removable rules */
  if (i==n)
  {
    for (i=0; i<n; i++)
      if (valid[i]) break;
    if (i==n) goto ok; else
    cerr << "Recursion found in rules: ";
    for (i=0; i<n; i++)
      if (valid[i]) cerr << '`' << getNonterminal(-i-1) << "' ";
    cerr << endl;
    return false;
  }
  /* remove rule i and i from the lists */
  else
  {
    valid[i]=false;
    for (int z=0; z<n; z++)
      if (valid[z])
        isOnRight[z].remove(&i);
  }
  goto loop;
 ok:
  delete [] isOnRight;
  delete [] valid;
  /* now make checkboxes the correct title */
  for (i=0; i<n; i++)
    if (getRule(-i-1)) getRule(-i-1)->correctCheckBox();

  return true;
}