#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_KDE
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#else // QT_ONLY
#include <qapplication.h>
#include <qstring.h>
#include <iostream.h>
#endif // HAVE_KDE

#include "kaptain.h"
#include "kaptainwizard.h"
#include "kgrammar.h"

KGrammar * gr;
bool test_flag=false;
bool verbose_flag=false;

#ifdef HAVE_KDE
static const char *description =
	I18N_NOOP("Kaptain - the universal graphical front-end");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
static KCmdLineOptions options[] =
{
  { "t", 0 , 0 },
  { "test", I18N_NOOP("Test mode - don't execute commands just print them."), 0 },
  { "V", 0 , 0 },
  { "verbose", I18N_NOOP("Verbose mode - print messages while parsing grammars."), 0 },
  { "+grammar", I18N_NOOP("Grammar script file."), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};
#endif // HAVE_KDE

int main(int argc, char *argv[])
{
  const char * filename=0;
#ifdef HAVE_KDE
  KAboutData aboutData( "kaptain", I18N_NOOP("Kaptain"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2000,2001 Terk Zsolt");
  aboutData.addAuthor("Terek Zsolt",0, "terek@users.sourceforge.net");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KCmdLineArgs * args=KCmdLineArgs::parsedArgs();
  if (args->isSet("test"))    test_flag=true;
  if (args->isSet("verbose")) verbose_flag=true;
  if (args->count()!=0)
    filename=args->arg(0);
#else // QT_ONLY
  int n=0;
  while (argv[++n])
  {
    if (QString(argv[n])==("-V") || QString(argv[n])==("--verbose"))
      verbose_flag=true; else
    if (QString(argv[n])==("-t") || QString(argv[n])==("--test"))
      test_flag=true; else
    if (QString(argv[n])==("-a") || QString(argv[n])==("--author") || QString(argv[n])==("--about"))
      {
        cout << "Kaptain " << VERSION << '\n' << "(c) 2000,2001 Terk Zsolt, terek@users.sourceforge.net\n";
        return 0;
      }
      else
      filename=argv[n];
  }
#endif // HAVE_KDE

  gr=new KGrammar();

  if (!(gr->parse(filename))) return -1;

#ifdef HAVE_KDE
  KApplication app;
#else //QT_ONLY
  QApplication app(argc, argv);
#endif // HAVE_KDE

  KRule * start=gr->getStartRule();
  QDialog * kaptain;
  if (start->isWizard())
    kaptain=new KaptainWizard(start);
  else
    kaptain=new Kaptain(start);

  app.setMainWidget(kaptain);

  return kaptain->exec();
}
