/*
    kamefuview.h - Kamefu Main View

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef __KAMEFUVIEW_H__
#define __KAMEFUVIEW_H__

#include <qwidget.h>
#include <rommetainformation.h>
#include <kurl.h>

namespace KIO
{
	class Job;
}

/**
 * @author Michaël Larouche
 */
class KamefuView : public QWidget
{
Q_OBJECT
public:
	KamefuView(QWidget *parent = 0, const char *name = 0);
	~KamefuView();

	/**
	 * Return the collection size.
	 */
	int collectionSize() const;

signals:
	void romExecuted(const QString &romName);
	void romSelected(const QString &romName);
	/**
	 * Emitted when roms are deleted or trashed.
	 * Used to update the collection count.
	 */
	void romsDeletedOrTrashed();

public slots:
	void clearRomList();
	void fillFilters();
	void addRomListViewItem(const Kamefu::RomMetaInformation &romMetaInfo);
	void fillRoms(const QString &query);

	/**
	 * Update the current selected rom in list view after being edited.
	 * @param romUrl URL is used to identity the rom.
	 */
	void updateSelectedRomInformation(const QString &romUrl);
	/**
	 * Update the selected ROms in list view after being edited.
	 * @param romList URL is used to identity the rom.
	 */
	void updateSelectedRomInformation(const KURL::List &romList);
	/**
	 * Read the size settings
	 */
	void readSettings();
	/**
	 * Save the size settings
	 */
	void saveSettings();

	/**
	 * View/Edit ROms meta information.
	 * @param romList ROMs to edit.
	 */ 
	void editRomsInformation(const KURL::List &romList);
	/**
	 * Delete Roms
	 * @param romList Roms to delete.
	 */
	void deleteRoms(const KURL::List &romList);
	/**
	 * Trash Roms
	 * @param romList Roms to trash.
	 */
	 void trashRoms(const KURL::List &romList);

private slots:
	/**
	 * @internal
	 * Called when the delete/trash operation is done.
	 * Remove the deleted/trashed roms from database.
	 */
	void romJobDone(KIO::Job *job);

private:
	class Private;
	Private *d;
};

#endif
