/*
    filterlist.cpp - Show System, Country, Editor filter list.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef FILTERLIST_H
#define FILTERLIST_H

#include <qwidget.h>

/**
 * @brief Show System, Country, Editor filter list.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class FilterList : public QWidget
{
	Q_OBJECT
public:
	/**
	 * @brief Create a new filter list.
	 * @param parent Parent widget
	 * @param name object name
	 */
	FilterList(QWidget *parent = 0, const char *name = 0);
	/**
	 * @brief d-tor
	 */
	~FilterList();

public slots:
	/**
	 * @brief Fill filter list with new values
	 */
	void fillFilterLists();
	
signals:
	/**
	 * @brief Refresh collection list.
	 * Emitted when the filter query has changed.
	 */
	void refreshRoms(const QString&);
	
private slots:
	/**
	 * @internal
	 * System selection changed.
	 * @param system Selected system
	 */
	void systemChanged(const QString &system);
	/**
	 * @internal
	 * Country selection changed.
	 * @param country Selected country.
	 */
	void countryChanged(const QString &country);
	/**
	 * @internal
	 * Editor selection changed.
	 * @param editor Selected editor.
	 */
	void editorChanged(const QString &editor);
private:
	/**
	 * @internal
	 * Fill country listbox based on given system
	 * @param system Gived system
	 */
	void fillCountries(const QString &system);
	/**
	 * @internal
	 * Fill editor listbox based on given country.
	 * @param country given country.
	 */
	void fillEditors(const QString &country);
	/**
	 * @internal
	 * Create the filter query and emit refreshRoms() signal if needed.
	 */
	void filterRoms();
	
	/**
	 * @internal
	 * disconnect selection signal magic.
	 */
	void disconnectSignals();
	/**
	 * @internal
	 * connect selection signal magic.
	 */
	void connectSignals();

	class Private;
	Private *d;
};

#endif
