#ifndef KADU_USERLIST_H
#define KADU_USERLIST_H

#include <qstring.h>
#include "usergroup.h"

/**
	\class UserList
	\brief Klasa reprezentujca list kontaktw.
**/
class UserList : public UserGroup
{
	Q_OBJECT
	public:
		/**
			\fn static void initModule()
			Inicjuje modu listy kontaktw.
		**/
		static void initModule();

		/**
			\fn static void closeModule()
			Sprzta po module listy kontaktw.
		**/
		static void closeModule();

	public slots:
		/**
			\fn bool readFromFile()
			Wczytuje list kontaktw z plikw "userlist"
			i "userattribs" z katalogu z ustawieniami.
			TODO: obsolete, do wywalenia w 0.6
			\return FALSE, gdy wystpiy bdy, lub TRUE w przeciwnym wypadku.
		**/
		bool readFromFile();

		/**
			\fn void merge(const QValueList<UserListElement> &list)
			Scala list kontaktw z podan list kontaktw \a userlist.
			\param userlist lista kontaktw z ktr naley scali
		**/
		void merge(const QValueList<UserListElement> &list);

		/**
			\fn void readFromConfig()
			Wczytuje list kontaktw z drzewa xml z konfiguracj
			programu. Poprzednie kontakty s usuwane.
		**/
		void readFromConfig();

		/**
			\fn void writeToConfig()
			Dodaje list kontaktw do drzewa xml z konfiguracj
			programu. Poprzednie kontakty s usuwane.
		**/
		void writeToConfig();

		/**
			\fn void setAllOffline(const QString &protocolName)
			\param protocolName identyfikator protokou
			Przestawia status wszystkich kontaktw
			dla wskazanego protokou na "niedostpny".

		**/
		void setAllOffline(const QString &protocolName);

		/**
			\fn void clear()
			Usuwa wszystkie kontakty.
		**/
		void clear();

		void addPerContactNonProtocolConfigEntry(const QString &attribute_name, const QString &internal_key);
		void removePerContactNonProtocolConfigEntry(const QString &attribute_name);
		void addPerContactProtocolConfigEntry(const QString &protocolName, const QString &attribute_name, const QString &internal_key);
		void removePerContactProtocolConfigEntry(const QString &protocolName, const QString &attribute_name);


	private:
		/**
			\fn UserList()
			Konstruktor standardowy.
		**/
		UserList();

		/**
			\fn ~UserList()
		**/
		virtual ~UserList();

		QMap<QString, QString> nonProtoKeys;
		QMap<QString, QMap<QString, QString> > protoKeys;

		void initKeys();
};

extern UserList *userlist;

#endif
