#ifndef SPELLCHECKER_H
#define SPELLCHECKER_H

#include <qobject.h>
#include <qstringlist.h>
#include <qsyntaxhighlighter.h>
#include <qmap.h>

#include "configuration_aware_object.h"
#include "main_configuration_window.h"

class AspellSpeller;
class AspellConfig;
class ChatWidget;
class CustomInput;
class HtmlDocument;
class QPopupMenu;
class QListBoxItem;
class QTimer;

class SpellChecker : public ConfigurationUiHandler, ConfigurationAwareObject
{
    Q_OBJECT

	typedef QMap<QString, AspellSpeller *> Checkers;
	QTimer *myWakeupTimer;
	Checkers checkers;
	AspellConfig *spellConfig;
	QString beginMark;
	bool isTagMyOwn(HtmlDocument &, int);
	void updateChat(CustomInput *edit, QString text);

	QListBox *availList;
	QListBox *checkList;

	void import_0_5_0_Configuration();
	void createDefaultConfiguration();

private slots:
	void executeChecking();
	void configurationWindowApplied();

protected:
	virtual void configurationUpdated();

public:
	SpellChecker();
	virtual ~SpellChecker();
	virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);

	QStringList notCheckedLanguages();
	QStringList checkedLanguages();
	bool addCheckedLang(QString& name);
	void removeCheckedLang(QString& name);
	void buildMarkTag();
	bool buildCheckers();

public slots:
	void chatCreated(ChatWidget *);
	void cleanMessage(ChatWidget *);
	void configForward();
	void configBackward();
	void configForward2(QListBoxItem *);
	void configBackward2(QListBoxItem *);

};

extern SpellChecker* spellcheck;

#endif
