#ifndef MODULE_BITMAP_BITMAP_COMPOSITE_H
#define MODULE_BITMAP_BITMAP_COMPOSITE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <k3dsdk/ibitmap_sink.h>
#include <k3dsdk/ibitmap_source.h>
#include <k3dsdk/property_collection.h>
#include <k3dsdk/bitmap.h>

namespace libk3dbitmap
{

template<typename base_t>
class bitmap_composite :
	public base_t,
	public k3d::ibitmap_source,
	public k3d::ibitmap_sink
{
public:
	bitmap_composite(k3d::idocument& Document) :
		base_t(Document),
		m_bitmap_a(k3d::init_name("input_a") + k3d::init_description("A input bitmap [bitmap]") + k3d::init_value<k3d::bitmap*>(0) + k3d::init_document(Document)),
		m_bitmap_b(k3d::init_name("input_b") + k3d::init_description("B input bitmap [bitmap]") + k3d::init_value<k3d::bitmap*>(0) + k3d::init_document(Document)),
		m_bitmap_o(k3d::init_name("output") + k3d::init_description("Output bitmap [bitmap]") + k3d::init_document(Document))
	{
		base_t::register_property(m_bitmap_a);
		base_t::register_property(m_bitmap_b);
		base_t::register_property(m_bitmap_o);
	}

	k3d::iproperty& bitmap_source_output()
	{
		return m_bitmap_o;
	}

	k3d::iproperty& bitmap_sink_input()
	{
		return m_bitmap_a;
	}

protected:
	k3d_data_property(k3d::bitmap*, k3d::immutable_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_bitmap_a;
	k3d_data_property(k3d::bitmap*, k3d::immutable_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_bitmap_b;
	k3d_read_only_data_property(k3d::bitmap*, k3d::immutable_name, k3d::change_signal, k3d::no_undo, k3d::demand_storage, k3d::no_constraint) m_bitmap_o;
};

} // namespace libk3dbitmap

#endif // !MODULE_BITMAP_BITMAP_COMPOSITE_H


