#ifndef K3DUI_MENU_ITEM_H
#define K3DUI_MENU_ITEM_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::menu_item::control class
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include "hotkey.h"
#include "k3duserinterfaceelement.h"

#include <k3dsdk/signal_system.h>
#include <sdpgtk/sdpgtkobjectcontainer.h>

namespace sdpxml { class Document; }
namespace sdpxml { class Element; }

namespace k3d
{

// Forward declarations
class idocument;
class iobject;

namespace menu_item
{

/////////////////////////////////////////////////////////////////////////////
// control

class control :
	public k3dUserInterfaceElement
{
	typedef k3dUserInterfaceElement base;

public:
	control(k3d::iunknown* CommandNodeParent, std::string CommandNodeName);
	~control();

	/// Updates the menu item label
	void set_text(const std::string& Text);
	/// Controls sensitivity of the menu item
	void set_sensitive(const bool Sensitive);
	/// Defines a signal that will be emitted when the menu item is activated
	typedef SigC::Signal0<void> activated_signal_t;
	/// Defines a signal that will be emitted when the menu item is activated
	activated_signal_t& signal_activate();

	// Internal ugliness
	bool Create(sdpGtkIObjectContainer* ObjectContainer, sdpxml::Document& Document, sdpxml::Element& Element);
	const std::string CustomType() const;
	bool execute_command(const std::string& Command, const std::string& Arguments);

private:
	/// Called to handle SDPGTK events
	void OnEvent(sdpGtkEvent* Event);
	/// Called when the item is activated
	void on_activate();

	/// Hotkey object for (optionally) responding to hotkey events
	k3d::hotkey m_hotkey;
	/// Signal emitted whenever the menu item is activated
	activated_signal_t m_signal_activate;

	/// Private storage for the control state
	class state;
	state* const m_state;
};

} // namespace menu_item

} // namespace k3d

#endif // !K3DUI_MENU_ITEM_H


