#ifndef K3DUI_HOTKEY_H
#define K3DUI_HOTKEY_H

#include <k3dsdk/keyboard.h>
#include <k3dsdk/signal_system.h>

// Forward declarations
namespace sdpxml { class Document; }
namespace sdpxml { class Element; }

namespace k3d
{

class hotkey :
	public SigC::Object
{
public:
	hotkey(k3d::icommand_node& Owner);

	bool load(sdpxml::Document& Document, sdpxml::Element& Element);
	
	typedef SigC::Signal0<void> event_signal_t;
	event_signal_t& event_signal();

private:
	bool on_key_event(k3d::icommand_node& CommandNode, key_modifiers Modifiers, ikeyboard::key_value_t Key);
	
	typedef enum
	{
		APPLICATION_CONTEXT,
		DOCUMENT_CONTEXT,
		OBJECT_CONTEXT,
		OWNER_CONTEXT
	} context_t;
	
	icommand_node& m_owner;	
	context_t m_context;
	key_modifiers m_modifiers;
	key_modifiers m_mask;
	unsigned int m_key;
	SigC::Connection m_keyboard_connection;
	event_signal_t m_event_signal;
};
	
} // namespace k3d

#endif // !K3DUI_HOTKEY_H

