#ifndef K3DSDK_ISELECTABLE_H
#define K3DSDK_ISELECTABLE_H

#include "iunknown.h"

namespace k3d
{

/// Abstract interface for an object that supports a boolean "selected" state
class iselectable :
	public virtual iunknown
{
public:
	/// Returns the "selected" state of the object
	virtual bool is_selected() = 0;
	/// Selects the object
	virtual void select() = 0;
	/// Deselects the object
	virtual void deselect() = 0;
	
protected:
	iselectable() {}
	iselectable(const iselectable&) {}
	iselectable& operator=(const iselectable&) { return *this; }
	virtual ~iselectable() {}
};

} // namespace k3d

#endif // !K3DSDK_ISELECTABLE_H
