#ifndef K3DSDK_IDAG_H
#define K3DSDK_IDAG_H

#include "iunknown.h"
#include "signal_system.h"

#include <map>
#include <vector>

namespace k3d
{

// Forward declarations
class iproperty;

/// Abstract interface for a Directed Acyclic Graph of dependencies between document plugin properties
class idag :
	public virtual iunknown
{
public:
	/// Defines a dependency between two properties
	typedef std::pair<iproperty*, iproperty*> dependency_t;
	/// Defines a set of dependencies between properties - the map key is the dependent property and must not be NULL.  The map value is the property it depends upon, and may be NULL.
	typedef std::map<iproperty*, iproperty*> dependencies_t;
	/// Defines a collection of properties
	typedef std::vector<iproperty*> properties_t;

	/// Updates dependencies between a set of properties
	virtual void set_dependencies(dependencies_t& Dependencies) = 0;

	/// Returns the dependency for a given property - may return NULL for no dependency
	virtual iproperty* dependency(iproperty& Target) = 0;

	/// Returns the set of all dependencies between properties
	virtual const dependencies_t& dependencies() = 0;
	
	/// Defines a signal that will be emitted whenever a set of dependencies are altered
	typedef SigC::Signal1<void, const dependencies_t&> dependency_signal_t;
	virtual dependency_signal_t& dependency_signal() = 0;
	
protected:
	idag() {}
	idag(const idag&) {}
	idag& operator=(const idag&) { return *this; }
	virtual ~idag() {}
};



} // namespace k3d

#endif // !K3DSDK_IDAG_H
