#include "glutility_private.h"
#include <map>

namespace k3d
{

namespace implementation_private
{

/// Note - 32-bit implementations are inlined in glutility_private.h
#if SIZEOF_VOIDP == 8

static std::map<const iunknown*, GLuint> gl_pointer_name_map;
static std::map<GLuint, const iunknown*> gl_name_pointer_map;

void gl_load_name(const iunknown* const Name)
{
	// This works because std::map::insert() is a no-op if the key already exists
	gl_pointer_name_map.insert(std::make_pair(Name, gl_pointer_name_map.size()));
	gl_name_pointer_map.insert(std::make_pair(gl_pointer_name_map[Name], Name));

	::glLoadName(gl_pointer_name_map[Name]);
}

void gl_push_name(const iunknown* const Name)
{
	// This works because std::map::insert() is a no-op if the key already exists
	gl_pointer_name_map.insert(std::make_pair(Name, gl_pointer_name_map.size()));
	gl_name_pointer_map.insert(std::make_pair(gl_pointer_name_map[Name], Name));

	::glPushName(gl_pointer_name_map[Name]);
}

void gl_pop_name()
{
	::glPopName();
}

iunknown* gl_get_name(GLuint*& Names)
{
	iunknown* result = const_cast<iunknown*>(gl_name_pointer_map[*Names]);
	++Names;
	
	return result;
}

#endif
	
} // namespace implementation_private
	
} // namespace k3d

